/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.function.DatabaseClient;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.support.R2dbcRepositoryFactory;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class R2dbcRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private DatabaseClient client;
    @Nullable
    private MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
    @Nullable
    private ReactiveDataAccessStrategy dataAccessStrategy;
    private boolean mappingContextConfigured = false;

    public R2dbcRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setDatabaseClient(@Nullable DatabaseClient client) {
        this.client = client;
    }

    protected void setMappingContext(@Nullable MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        if (mappingContext != null) {
            this.mappingContext = mappingContext;
            this.mappingContextConfigured = true;
        }
    }

    public void setDataAccessStrategy(@Nullable ReactiveDataAccessStrategy dataAccessStrategy) {
        this.dataAccessStrategy = dataAccessStrategy;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.client, this.mappingContext);
    }

    protected RepositoryFactorySupport getFactoryInstance(DatabaseClient client, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext) {
        return new R2dbcRepositoryFactory(client, mappingContext, this.dataAccessStrategy);
    }

    public void afterPropertiesSet() {
        Assert.state((this.client != null ? 1 : 0) != 0, (String)"DatabaseClient must not be null!");
        Assert.state((this.dataAccessStrategy != null ? 1 : 0) != 0, (String)"ReactiveDataAccessStrategy must not be null!");
        if (!this.mappingContextConfigured) {
            this.setMappingContext((MappingContext<?, ?>)new RelationalMappingContext());
        }
        super.afterPropertiesSet();
    }
}

