/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DefaultStatementMapper;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.util.Assert;

public interface StatementMapper {
    public static StatementMapper create(R2dbcDialect dialect, R2dbcConverter converter) {
        Assert.notNull((Object)dialect, (String)"R2dbcDialect must not be null");
        Assert.notNull((Object)converter, (String)"R2dbcConverter must not be null");
        return new DefaultStatementMapper(dialect, converter);
    }

    public <T> TypedStatementMapper<T> forType(Class<T> var1);

    public PreparedOperation<?> getMappedObject(SelectSpec var1);

    public PreparedOperation<?> getMappedObject(InsertSpec var1);

    public PreparedOperation<?> getMappedObject(UpdateSpec var1);

    public PreparedOperation<?> getMappedObject(DeleteSpec var1);

    default public SelectSpec createSelect(String table) {
        return SelectSpec.create(table);
    }

    default public SelectSpec createSelect(SqlIdentifier table) {
        return SelectSpec.create(table);
    }

    default public InsertSpec createInsert(String table) {
        return InsertSpec.create(table);
    }

    default public InsertSpec createInsert(SqlIdentifier table) {
        return InsertSpec.create(table);
    }

    default public UpdateSpec createUpdate(String table, Update update) {
        return UpdateSpec.create(table, update);
    }

    default public UpdateSpec createUpdate(SqlIdentifier table, Update update) {
        return UpdateSpec.create(table, update);
    }

    default public DeleteSpec createDelete(String table) {
        return DeleteSpec.create(table);
    }

    default public DeleteSpec createDelete(SqlIdentifier table) {
        return DeleteSpec.create(table);
    }

    @Nullable
    default public RenderContext getRenderContext() {
        return null;
    }

    public static class SelectSpec {
        private final Table table;
        private final List<String> projectedFields;
        private final List<Expression> selectList;
        @Nullable
        private final CriteriaDefinition criteria;
        private final Sort sort;
        private final long offset;
        private final int limit;
        private final boolean distinct;
        private final LockMode lockMode;

        protected SelectSpec(Table table, List<String> projectedFields, List<Expression> selectList, @Nullable CriteriaDefinition criteria, Sort sort, int limit, long offset, boolean distinct, LockMode lockMode) {
            this.table = table;
            this.projectedFields = projectedFields;
            this.selectList = selectList;
            this.criteria = criteria;
            this.sort = sort;
            this.offset = offset;
            this.limit = limit;
            this.distinct = distinct;
            this.lockMode = lockMode;
        }

        public static SelectSpec create(String table) {
            return SelectSpec.create(SqlIdentifier.unquoted((String)table));
        }

        public static SelectSpec create(SqlIdentifier table) {
            List<String> projectedFields = Collections.emptyList();
            List<Expression> selectList = Collections.emptyList();
            return new SelectSpec(Table.create((SqlIdentifier)table), projectedFields, selectList, (CriteriaDefinition)Criteria.empty(), Sort.unsorted(), -1, -1L, false, null);
        }

        public SelectSpec doWithTable(BiFunction<Table, SelectSpec, SelectSpec> function) {
            return function.apply(this.getTable(), this);
        }

        public SelectSpec withProjection(String ... projectedFields) {
            return this.withProjection(Arrays.stream(projectedFields).map(arg_0 -> ((Table)this.table).column(arg_0)).collect(Collectors.toList()));
        }

        public SelectSpec withProjection(SqlIdentifier ... projectedFields) {
            return this.withProjection(Arrays.stream(projectedFields).map(arg_0 -> ((Table)this.table).column(arg_0)).collect(Collectors.toList()));
        }

        public SelectSpec withProjection(Expression ... expressions) {
            ArrayList<Expression> selectList = new ArrayList<Expression>(this.selectList);
            selectList.addAll(Arrays.asList(expressions));
            return new SelectSpec(this.table, this.projectedFields, selectList, this.criteria, this.sort, this.limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec withProjection(Collection<Expression> projectedFields) {
            ArrayList<Expression> selectList = new ArrayList<Expression>(this.selectList);
            selectList.addAll(projectedFields);
            return new SelectSpec(this.table, this.projectedFields, selectList, this.criteria, this.sort, this.limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec withCriteria(CriteriaDefinition criteria) {
            return new SelectSpec(this.table, this.projectedFields, this.selectList, criteria, this.sort, this.limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec withSort(Sort sort) {
            if (sort.isSorted()) {
                return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, sort, this.limit, this.offset, this.distinct, this.lockMode);
            }
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, this.limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec withPage(Pageable page) {
            if (page.isPaged()) {
                Sort sort = page.getSort();
                return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, sort.isSorted() ? sort : this.sort, page.getPageSize(), page.getOffset(), this.distinct, this.lockMode);
            }
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, this.limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec offset(long offset) {
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, this.limit, offset, this.distinct, this.lockMode);
        }

        public SelectSpec limit(int limit) {
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, limit, this.offset, this.distinct, this.lockMode);
        }

        public SelectSpec distinct() {
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, this.limit, this.offset, true, this.lockMode);
        }

        public SelectSpec lock(LockMode lockMode) {
            return new SelectSpec(this.table, this.projectedFields, this.selectList, this.criteria, this.sort, this.limit, this.offset, this.distinct, lockMode);
        }

        @Nullable
        public LockMode getLock() {
            return this.lockMode;
        }

        public Table getTable() {
            return this.table;
        }

        public List<Expression> getSelectList() {
            return Collections.unmodifiableList(this.selectList);
        }

        @Nullable
        public CriteriaDefinition getCriteria() {
            return this.criteria;
        }

        public Sort getSort() {
            return this.sort;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }

    public static class InsertSpec {
        private final SqlIdentifier table;
        private final Map<SqlIdentifier, Parameter> assignments;

        protected InsertSpec(SqlIdentifier table, Map<SqlIdentifier, Parameter> assignments) {
            this.table = table;
            this.assignments = assignments;
        }

        public static InsertSpec create(String table) {
            return InsertSpec.create(SqlIdentifier.unquoted((String)table));
        }

        public static InsertSpec create(SqlIdentifier table) {
            return new InsertSpec(table, Collections.emptyMap());
        }

        public InsertSpec withColumn(String column, Parameter value) {
            return this.withColumn(SqlIdentifier.unquoted((String)column), value);
        }

        public InsertSpec withColumn(SqlIdentifier column, Parameter value) {
            LinkedHashMap<SqlIdentifier, Parameter> values = new LinkedHashMap<SqlIdentifier, Parameter>(this.assignments);
            values.put(column, value);
            return new InsertSpec(this.table, values);
        }

        public SqlIdentifier getTable() {
            return this.table;
        }

        public Map<SqlIdentifier, Parameter> getAssignments() {
            return Collections.unmodifiableMap(this.assignments);
        }
    }

    public static class UpdateSpec {
        private final SqlIdentifier table;
        @Nullable
        private final Update update;
        @Nullable
        private final CriteriaDefinition criteria;

        protected UpdateSpec(SqlIdentifier table, @Nullable Update update, @Nullable CriteriaDefinition criteria) {
            this.table = table;
            this.update = update;
            this.criteria = criteria;
        }

        public static UpdateSpec create(String table, Update update) {
            return UpdateSpec.create(SqlIdentifier.unquoted((String)table), update);
        }

        public static UpdateSpec create(SqlIdentifier table, Update update) {
            return new UpdateSpec(table, update, (CriteriaDefinition)Criteria.empty());
        }

        public UpdateSpec withCriteria(CriteriaDefinition criteria) {
            return new UpdateSpec(this.table, this.update, criteria);
        }

        public SqlIdentifier getTable() {
            return this.table;
        }

        @Nullable
        public Update getUpdate() {
            return this.update;
        }

        @Nullable
        public CriteriaDefinition getCriteria() {
            return this.criteria;
        }
    }

    public static class DeleteSpec {
        private final SqlIdentifier table;
        @Nullable
        private final CriteriaDefinition criteria;

        protected DeleteSpec(SqlIdentifier table, CriteriaDefinition criteria) {
            this.table = table;
            this.criteria = criteria;
        }

        public static DeleteSpec create(String table) {
            return DeleteSpec.create(SqlIdentifier.unquoted((String)table));
        }

        public static DeleteSpec create(SqlIdentifier table) {
            return new DeleteSpec(table, (CriteriaDefinition)Criteria.empty());
        }

        public DeleteSpec withCriteria(CriteriaDefinition criteria) {
            return new DeleteSpec(this.table, criteria);
        }

        public SqlIdentifier getTable() {
            return this.table;
        }

        @Nullable
        public CriteriaDefinition getCriteria() {
            return this.criteria;
        }
    }

    public static interface TypedStatementMapper<T>
    extends StatementMapper {
    }
}

