/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveUpdateOperation;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

record ReactiveUpdateOperationSupport(R2dbcEntityTemplate template) implements ReactiveUpdateOperation
{
    @Override
    public ReactiveUpdateOperation.ReactiveUpdate update(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveUpdateSupport(this.template, domainType, Query.empty(), null);
    }

    static class ReactiveUpdateSupport
    implements ReactiveUpdateOperation.ReactiveUpdate,
    ReactiveUpdateOperation.TerminatingUpdate {
        private final R2dbcEntityTemplate template;
        private final Class<?> domainType;
        private final Query query;
        private final @Nullable SqlIdentifier tableName;

        ReactiveUpdateSupport(R2dbcEntityTemplate template, Class<?> domainType, Query query, @Nullable SqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.tableName = tableName;
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithQuery inTable(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveUpdateSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingUpdate matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ReactiveUpdateSupport(this.template, this.domainType, query, this.tableName);
        }

        @Override
        public Mono<Long> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return this.template.doUpdate(this.query, update, this.domainType, this.getTableName());
        }

        private SqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

