/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDeleteOperation;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

record ReactiveDeleteOperationSupport(R2dbcEntityTemplate template) implements ReactiveDeleteOperation
{
    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveDeleteSupport(this.template, domainType, Query.empty(), null);
    }

    static class ReactiveDeleteSupport
    implements ReactiveDeleteOperation.ReactiveDelete,
    ReactiveDeleteOperation.TerminatingDelete {
        private final R2dbcEntityTemplate template;
        private final Class<?> domainType;
        private final Query query;
        private final @Nullable SqlIdentifier tableName;

        ReactiveDeleteSupport(R2dbcEntityTemplate template, Class<?> domainType, Query query, @Nullable SqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.tableName = tableName;
        }

        @Override
        public ReactiveDeleteOperation.DeleteWithQuery from(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ReactiveDeleteOperation.TerminatingDelete matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ReactiveDeleteSupport(this.template, this.domainType, query, this.tableName);
        }

        @Override
        public Mono<Long> all() {
            return this.template.doDelete(this.query, this.domainType, this.getTableName());
        }

        private SqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

