/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.springframework.data.redis.serializer.DefaultRedisElementReader;
import org.springframework.data.redis.serializer.DefaultRedisElementWriter;
import org.springframework.data.redis.serializer.DefaultSerializationPair;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

class RedisSerializerToSerializationPairAdapter<T>
implements RedisSerializationContext.SerializationPair<T> {
    private static final RedisSerializerToSerializationPairAdapter<?> RAW = new RedisSerializerToSerializationPairAdapter(null);
    private final DefaultSerializationPair pair;

    protected RedisSerializerToSerializationPairAdapter(RedisSerializer<T> serializer) {
        this.pair = new DefaultSerializationPair<T>(new DefaultRedisElementReader<T>(serializer), new DefaultRedisElementWriter<T>(serializer));
    }

    public static <T> RedisSerializationContext.SerializationPair<T> raw() {
        return RAW;
    }

    public static <T> RedisSerializationContext.SerializationPair<T> from(RedisSerializer<T> redisSerializer) {
        Assert.notNull(redisSerializer, (String)"RedisSerializer must not be null!");
        return new RedisSerializerToSerializationPairAdapter<T>(redisSerializer);
    }

    @Override
    public RedisElementReader<T> getReader() {
        return this.pair.getReader();
    }

    @Override
    public RedisElementWriter<T> getWriter() {
        return this.pair.getWriter();
    }
}

