/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.util.Assert;

public class RedisStaticMasterSlaveConfiguration
implements RedisConfiguration,
RedisConfiguration.StaticMasterSlaveConfiguration {
    private static final int DEFAULT_PORT = 6379;
    private List<RedisStandaloneConfiguration> nodes = new ArrayList<RedisStandaloneConfiguration>();
    private int database;
    private RedisPassword password = RedisPassword.none();

    public RedisStaticMasterSlaveConfiguration(String hostName) {
        this(hostName, 6379);
    }

    public RedisStaticMasterSlaveConfiguration(String hostName, int port) {
        this.addNode(hostName, port);
    }

    public void addNode(String hostName, int port) {
        this.addNode(new RedisStandaloneConfiguration(hostName, port));
    }

    private void addNode(RedisStandaloneConfiguration node) {
        Assert.notNull((Object)node, (String)"RedisStandaloneConfiguration must not be null!");
        node.setPassword(this.password);
        node.setDatabase(this.database);
        this.nodes.add(node);
    }

    public RedisConfiguration.StaticMasterSlaveConfiguration node(String hostName) {
        return this.node(hostName, 6379);
    }

    public RedisStaticMasterSlaveConfiguration node(String hostName, int port) {
        this.addNode(hostName, port);
        return this;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
        this.nodes.forEach(it -> it.setDatabase(this.database));
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null!");
        this.password = password;
        this.nodes.forEach(it -> it.setPassword(password));
    }

    @Override
    public List<RedisStandaloneConfiguration> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

