/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisClusterHashCommands
implements RedisHashCommands {
    @NonNull
    private final JedisClusterConnection connection;

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            return this.connection.getCluster().hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        try {
            return this.connection.getCluster().hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(hashes, (String)"Hashes must not be null!");
        try {
            this.connection.getCluster().hmset(key, hashes);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            return this.connection.getCluster().hincrBy(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            return this.connection.getCluster().hincrByFloat(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        try {
            return this.connection.getCluster().hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)fields, (String)"Fields must not be null!");
        try {
            return this.connection.getCluster().hdel(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return new ArrayList<byte[]>(this.connection.getCluster().hvals(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(final byte[] key, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new ScanCursor<Map.Entry<byte[], byte[]>>(options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterHashCommands.this.connection.getCluster().hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(result.getStringCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        return (Long)Long.class.cast(this.connection.execute("HSTRLEN", key, Collections.singleton(field)));
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    public JedisClusterHashCommands(@NonNull JedisClusterConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

