/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;

class JedisKeyCommands
implements RedisKeyCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public Boolean exists(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().exists(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().exists(key)));
                return null;
            }
            return this.connection.getJedis().exists(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().exists(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().exists(keys)));
                return null;
            }
            return this.connection.getJedis().exists(keys);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().del(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().del(keys)));
                return null;
            }
            return this.connection.getJedis().del(keys);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        return (Long)Long.class.cast(this.connection.execute("UNLINK", keys));
    }

    @Override
    public DataType type(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().type(key), JedisConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().type(key), JedisConverters.stringToDataType()));
                return null;
            }
            return JedisConverters.toDataType(this.connection.getJedis().type(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        return (Long)Long.class.cast(this.connection.execute("TOUCH", keys));
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().keys(pattern)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().keys(pattern)));
                return null;
            }
            return this.connection.getJedis().keys(pattern);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (JedisKeyCommands.this.isQueueing() || JedisKeyCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisKeyCommands.this.connection.getJedis().scan(Long.toString(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().randomKeyBinary()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().randomKeyBinary()));
                return null;
            }
            return this.connection.getJedis().randomBinaryKey();
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().rename(sourceKey, targetKey)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().rename(sourceKey, targetKey)));
                return;
            }
            this.connection.getJedis().rename(sourceKey, targetKey);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().renamenx(sourceKey, targetKey), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().renamenx(sourceKey, targetKey), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().renamenx(sourceKey, targetKey));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            return this.pExpire(key, TimeUnit.SECONDS.toMillis(seconds));
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().expire(key, (int)seconds));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pexpire(key, millis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pexpire(key, millis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().pexpire(key, millis));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().expireAt(key, unixTime));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().pexpireAt(key, unixTimeInMillis));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().persist(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().move(key, dbIndex));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().ttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().ttl(key)));
                return null;
            }
            return this.connection.getJedis().ttl(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().ttl(key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().ttl(key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.secondsToTimeUnit(this.connection.getJedis().ttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pttl(key)));
                return null;
            }
            return this.connection.getJedis().pttl(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().pttl(key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().pttl(key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.millisecondsToTimeUnit(this.connection.getJedis().pttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sort(key, sortParams)));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sort(key)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sort(key, sortParams)));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sort(key)));
                }
                return null;
            }
            return sortParams != null ? this.connection.getJedis().sort(key, sortParams) : this.connection.getJedis().sort(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, @Nullable SortParameters params, byte[] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sort(key, sortParams, storeKey)));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().sort(key, storeKey)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sort(key, sortParams, storeKey)));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().sort(key, storeKey)));
                }
                return null;
            }
            return sortParams != null ? this.connection.getJedis().sort(key, sortParams, storeKey) : this.connection.getJedis().sort(key, storeKey);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().dump(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().dump(key)));
                return null;
            }
            return this.connection.getJedis().dump(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)serializedValue, (String)"Serialized value must not be null!");
        if (ttlInMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TtlInMillis must be less than Integer.MAX_VALUE for restore in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            this.connection.getJedis().restore(key, (int)ttlInMillis, serializedValue);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().objectEncoding(key), JedisConverters::toEncoding, () -> ValueEncoding.RedisValueEncoding.VACANT));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().objectEncoding(key), JedisConverters::toEncoding, () -> ValueEncoding.RedisValueEncoding.VACANT));
                return null;
            }
            return JedisConverters.toEncoding(this.connection.getJedis().objectEncoding(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().objectIdletime(key), Converters::secondsToDuration));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().objectIdletime(key), Converters::secondsToDuration));
                return null;
            }
            return Converters.secondsToDuration(this.connection.getJedis().objectIdletime(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().objectRefcount(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().objectRefcount(key)));
                return null;
            }
            return this.connection.getJedis().objectRefcount(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    public JedisKeyCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

