/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.reactive.AwaitKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.core.ReactiveSetOperations;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\r\u001aU\u0010\u0000\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00040\b\"\u0002H\u0004H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001aA\u0010\n\u001a\u00020\u000b\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001aQ\u0010\r\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u000e\u001a\u0002H\u00022\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aO\u0010\r\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00122\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aQ\u0010\u0014\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u000e\u001a\u0002H\u00022\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aO\u0010\u0014\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00122\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aI\u0010\u0015\u001a\u00020\u000b\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0016\u001a\u0002H\u0004H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001aQ\u0010\u0018\u001a\u00020\u000b\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0019\u001a\u0002H\u00022\u0006\u0010\u0016\u001a\u0002H\u00042\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aC\u0010\u001a\u001a\u0004\u0018\u0001H\u0004\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001aC\u0010\u001b\u001a\u0004\u0018\u0001H\u0004\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001aU\u0010\u001c\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00040\b\"\u0002H\u0004H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001aA\u0010\u001d\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001aQ\u0010\u001e\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u000e\u001a\u0002H\u00022\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aO\u0010\u001e\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00122\u0006\u0010\u000f\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"addAndAwait", "", "K", "", "V", "Lorg/springframework/data/redis/core/ReactiveSetOperations;", "key", "values", "", "(Lorg/springframework/data/redis/core/ReactiveSetOperations;Ljava/lang/Object;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteAndAwait", "", "(Lorg/springframework/data/redis/core/ReactiveSetOperations;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "differenceAndStoreAndAwait", "otherKey", "destKey", "(Lorg/springframework/data/redis/core/ReactiveSetOperations;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "keys", "", "(Lorg/springframework/data/redis/core/ReactiveSetOperations;Ljava/util/Collection;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intersectAndStoreAndAwait", "isMemberAndAwait", "value", "(Lorg/springframework/data/redis/core/ReactiveSetOperations;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "moveAndAwait", "sourceKey", "popAndAwait", "randomMemberAndAwait", "removeAndAwait", "sizeAndAwait", "unionAndStoreAndAwait", "spring-data-redis"})
public final class ReactiveSetOperationsExtensionsKt {
    private static final <K, V> Object addAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, V[] values, Continuation<? super Long> continuation) {
        int $i$f$addAndAwait = 0;
        Mono<Long> mono = $receiver.add(key, Arrays.copyOf(values, values.length));
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"add(key, *values)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"add(key, *values).awaitSingle()");
        return object;
    }

    private static final <K, V> Object removeAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, V[] values, Continuation<? super Long> continuation) {
        int $i$f$removeAndAwait = 0;
        Mono<Long> mono = $receiver.remove(key, Arrays.copyOf(values, values.length));
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"remove(key, *values)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"remove(key, *values).awaitSingle()");
        return object;
    }

    private static final <K, V> Object popAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, Continuation<? super V> continuation) {
        int $i$f$popAndAwait = 0;
        Mono<V> mono = $receiver.pop(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"pop(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitFirstOrNull((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        return object;
    }

    private static final <K, V> Object moveAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K sourceKey, V value, K destKey, Continuation<? super Boolean> continuation) {
        int $i$f$moveAndAwait = 0;
        Mono<Boolean> mono = $receiver.move(sourceKey, value, destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"move(sourceKey, value, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"move(sourceKey, value, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object sizeAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, Continuation<? super Long> continuation) {
        int $i$f$sizeAndAwait = 0;
        Mono<Long> mono = $receiver.size(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"size(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"size(key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object isMemberAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, V value, Continuation<? super Boolean> continuation) {
        int $i$f$isMemberAndAwait = 0;
        Mono<Boolean> mono = $receiver.isMember(key, value);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"isMember(key, value)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"isMember(key, value).awaitSingle()");
        return object;
    }

    private static final <K, V> Object intersectAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, K otherKey, K destKey, Continuation<? super Long> continuation) {
        int $i$f$intersectAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.intersectAndStore(key, otherKey, destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"intersectAndStore(key, otherKey, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"intersectAndStore(key, o\u2026y, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object intersectAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, Collection<? extends K> keys, K destKey, Continuation<? super Long> continuation) {
        int $i$f$intersectAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.intersectAndStore(keys, (K)destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"intersectAndStore(keys, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"intersectAndStore(keys, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object unionAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, K otherKey, K destKey, Continuation<? super Long> continuation) {
        int $i$f$unionAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.unionAndStore(key, otherKey, destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"unionAndStore(key, otherKey, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"unionAndStore(key, other\u2026y, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object unionAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, Collection<? extends K> keys, K destKey, Continuation<? super Long> continuation) {
        int $i$f$unionAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.unionAndStore(keys, (K)destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"unionAndStore(keys, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"unionAndStore(keys, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object differenceAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, K otherKey, K destKey, Continuation<? super Long> continuation) {
        int $i$f$differenceAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.differenceAndStore(key, otherKey, destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"differenceAndStore(key, otherKey, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"differenceAndStore(key, \u2026y, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object differenceAndStoreAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, Collection<? extends K> keys, K destKey, Continuation<? super Long> continuation) {
        int $i$f$differenceAndStoreAndAwait = 0;
        Mono<Long> mono = $receiver.differenceAndStore(keys, (K)destKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"differenceAndStore(keys, destKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"differenceAndStore(keys, destKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object randomMemberAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, Continuation<? super V> continuation) {
        int $i$f$randomMemberAndAwait = 0;
        Mono<V> mono = $receiver.randomMember(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"randomMember(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitFirstOrNull((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        return object;
    }

    private static final <K, V> Object deleteAndAwait(@NotNull ReactiveSetOperations<K, V> $receiver, K key, Continuation<? super Boolean> continuation) {
        int $i$f$deleteAndAwait = 0;
        Mono<Boolean> mono = $receiver.delete(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"delete(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"delete(key).awaitSingle()");
        return object;
    }
}

