/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.convert.RedisTypeMapper;
import org.springframework.util.Assert;

public class DefaultRedisTypeMapper
extends DefaultTypeMapper<Bucket.BucketPropertyPath>
implements RedisTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private final @Nullable String typeKey;

    public DefaultRedisTypeMapper() {
        this(DEFAULT_TYPE_KEY);
    }

    public DefaultRedisTypeMapper(@Nullable String typeKey) {
        this(typeKey, Collections.singletonList(new SimpleTypeInformationMapper()));
    }

    public DefaultRedisTypeMapper(@Nullable String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        this(typeKey, new BucketTypeAliasAccessor(typeKey, (ConversionService)DefaultRedisTypeMapper.getConversionService()), mappingContext, Collections.singletonList(new SimpleTypeInformationMapper()));
    }

    public DefaultRedisTypeMapper(@Nullable String typeKey, List<? extends TypeInformationMapper> mappers) {
        this(typeKey, new BucketTypeAliasAccessor(typeKey, (ConversionService)DefaultRedisTypeMapper.getConversionService()), null, mappers);
    }

    private DefaultRedisTypeMapper(@Nullable String typeKey, TypeAliasAccessor<Bucket.BucketPropertyPath> accessor, @Nullable MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> mappers) {
        super(accessor, mappingContext, mappers);
        this.typeKey = typeKey;
    }

    private static GenericConversionService getConversionService() {
        GenericConversionService conversionService = new GenericConversionService();
        new RedisCustomConversions().registerConvertersIn((ConverterRegistry)conversionService);
        return conversionService;
    }

    @Override
    public boolean isTypeKey(@Nullable String key) {
        return key != null && this.typeKey != null && key.endsWith(this.typeKey);
    }

    static final class BucketTypeAliasAccessor
    implements TypeAliasAccessor<Bucket.BucketPropertyPath> {
        private final @Nullable String typeKey;
        private final ConversionService conversionService;

        BucketTypeAliasAccessor(@Nullable String typeKey, ConversionService conversionService) {
            Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
            this.typeKey = typeKey;
            this.conversionService = conversionService;
        }

        public Alias readAliasFrom(Bucket.BucketPropertyPath source) {
            if (this.typeKey == null || source instanceof List) {
                return Alias.NONE;
            }
            byte[] bytes = source.get(this.typeKey);
            if (bytes != null) {
                return Alias.ofNullable((Object)this.conversionService.convert((Object)bytes, String.class));
            }
            return Alias.NONE;
        }

        public void writeTypeTo(Bucket.BucketPropertyPath sink, Object alias) {
            if (this.typeKey != null) {
                if (alias instanceof byte[]) {
                    byte[] aliasBytes = (byte[])alias;
                    sink.put(this.typeKey, aliasBytes);
                } else {
                    sink.put(this.typeKey, (byte[])this.conversionService.convert(alias, byte[].class));
                }
            }
        }
    }
}

