/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import org.jspecify.annotations.Nullable;
import org.springframework.data.annotation.Id;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.util.Assert;

public class BasicRedisPersistentEntity<T>
extends BasicKeyValuePersistentEntity<T, RedisPersistentProperty>
implements RedisPersistentEntity<T> {
    private final TimeToLiveAccessor timeToLiveAccessor;

    public BasicRedisPersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver, TimeToLiveAccessor timeToLiveAccessor) {
        super(information, keySpaceResolver);
        Assert.notNull((Object)timeToLiveAccessor, (String)"TimeToLiveAccessor must not be null");
        this.timeToLiveAccessor = timeToLiveAccessor;
    }

    @Override
    public TimeToLiveAccessor getTimeToLiveAccessor() {
        return this.timeToLiveAccessor;
    }

    @Override
    public @Nullable RedisPersistentProperty getExplicitTimeToLiveProperty() {
        return (RedisPersistentProperty)this.getPersistentProperty(TimeToLive.class);
    }

    protected @Nullable RedisPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(RedisPersistentProperty property) {
        Assert.notNull((Object)((Object)property), (String)"Property must not be null");
        if (!property.isIdProperty()) {
            return null;
        }
        RedisPersistentProperty currentIdProperty = (RedisPersistentProperty)this.getIdProperty();
        if (currentIdProperty == null) {
            return property;
        }
        boolean currentIdPropertyIsExplicit = currentIdProperty.isAnnotationPresent(Id.class);
        boolean newIdPropertyIsExplicit = property.isAnnotationPresent(Id.class);
        if (currentIdPropertyIsExplicit && newIdPropertyIsExplicit) {
            throw new MappingException("Attempt to add explicit id property %s but already have a property %s registered as explicit id; Check your mapping configuration".formatted(property.getField(), currentIdProperty.getField()));
        }
        if (!currentIdPropertyIsExplicit && !newIdPropertyIsExplicit) {
            throw new MappingException("Attempt to add id property %s but already have a property %s registered as id; Check your mapping configuration".formatted(property.getField(), currentIdProperty.getField()));
        }
        if (newIdPropertyIsExplicit) {
            return property;
        }
        return null;
    }
}

