/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.function.Function;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.render.NamingStrategies;
import org.springframework.util.Assert;

public interface RenderNamingStrategy {
    default public String getName(Column column) {
        return column.getName();
    }

    default public String getReferenceName(Column column) {
        return column.getReferenceName();
    }

    default public String getName(Table table) {
        return table.getName();
    }

    default public String getReferenceName(Table table) {
        return table.getReferenceName();
    }

    default public RenderNamingStrategy map(Function<String, String> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
        return new NamingStrategies.DelegatingRenderNamingStrategy(this, mappingFunction);
    }
}

