/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.render.DeleteStatementVisitor;
import org.springframework.data.relational.core.sql.render.InsertStatementVisitor;
import org.springframework.data.relational.core.sql.render.NamingStrategies;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.Renderer;
import org.springframework.data.relational.core.sql.render.SelectStatementVisitor;
import org.springframework.data.relational.core.sql.render.SimpleRenderContext;
import org.springframework.data.relational.core.sql.render.UpdateStatementVisitor;
import org.springframework.util.Assert;

public class SqlRenderer
implements Renderer {
    private final RenderContext context;

    private SqlRenderer(RenderContext context) {
        Assert.notNull((Object)context, (String)"RenderContext must not be null!");
        this.context = context;
    }

    public static SqlRenderer create() {
        return new SqlRenderer(new SimpleRenderContext(NamingStrategies.asIs()));
    }

    public static SqlRenderer create(RenderContext context) {
        return new SqlRenderer(context);
    }

    public static String toString(Select select) {
        return SqlRenderer.create().render(select);
    }

    public static String toString(Insert insert) {
        return SqlRenderer.create().render(insert);
    }

    public static String toString(Update update) {
        return SqlRenderer.create().render(update);
    }

    public static String toString(Delete delete) {
        return SqlRenderer.create().render(delete);
    }

    @Override
    public String render(Select select) {
        SelectStatementVisitor visitor = new SelectStatementVisitor(this.context);
        select.visit(visitor);
        return visitor.getRenderedPart().toString();
    }

    @Override
    public String render(Insert insert) {
        InsertStatementVisitor visitor = new InsertStatementVisitor(this.context);
        insert.visit(visitor);
        return visitor.getRenderedPart().toString();
    }

    @Override
    public String render(Update update) {
        UpdateStatementVisitor visitor = new UpdateStatementVisitor(this.context);
        update.visit(visitor);
        return visitor.getRenderedPart().toString();
    }

    @Override
    public String render(Delete delete) {
        DeleteStatementVisitor visitor = new DeleteStatementVisitor(this.context);
        delete.visit(visitor);
        return visitor.getRenderedPart().toString();
    }
}

