/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ColumnVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class AssignmentVisitor
extends TypedSubtreeVisitor<Assignment> {
    private final ColumnVisitor columnVisitor;
    private final ExpressionVisitor expressionVisitor;
    private final RenderTarget target;
    private final StringBuilder part = new StringBuilder();

    AssignmentVisitor(RenderContext context, RenderTarget target) {
        this.columnVisitor = new ColumnVisitor(context, false, this.part::append);
        this.expressionVisitor = new ExpressionVisitor(context);
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Column) {
            return DelegatingVisitor.Delegation.delegateTo(this.columnVisitor);
        }
        if (segment instanceof Expression) {
            return DelegatingVisitor.Delegation.delegateTo(this.expressionVisitor);
        }
        throw new IllegalStateException("Cannot provide visitor for " + segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Column) {
            if (this.part.length() != 0) {
                this.part.append(" = ");
            }
            return super.leaveNested(segment);
        }
        if (segment instanceof Expression) {
            this.part.append(this.expressionVisitor.getRenderedPart());
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Assignment segment) {
        this.target.onRendered(new StringBuilder(this.part));
        this.part.setLength(0);
        return super.leaveMatched(segment);
    }
}

