/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Collections;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.util.Assert;

public abstract class AbstractRelationalConverter
implements RelationalConverter {
    private final RelationalMappingContext context;
    private final ConfigurableConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final CustomConversions conversions;

    public AbstractRelationalConverter(RelationalMappingContext context) {
        this(context, new CustomConversions(CustomConversions.StoreConversions.NONE, Collections.emptyList()), (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    public AbstractRelationalConverter(RelationalMappingContext context, CustomConversions conversions) {
        this(context, conversions, (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    private AbstractRelationalConverter(RelationalMappingContext context, CustomConversions conversions, ConfigurableConversionService conversionService, EntityInstantiators entityInstantiators) {
        Assert.notNull((Object)((Object)context), (String)"MappingContext must not be null");
        Assert.notNull((Object)conversions, (String)"CustomConversions must not be null");
        this.context = context;
        this.conversionService = conversionService;
        this.entityInstantiators = entityInstantiators;
        this.conversions = conversions;
        conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public CustomConversions getConversions() {
        return this.conversions;
    }

    @Override
    public EntityInstantiators getEntityInstantiators() {
        return this.entityInstantiators;
    }

    public RelationalMappingContext getMappingContext() {
        return this.context;
    }
}

