/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.relational.core.mapping.SqlIdentifierSanitizer;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;

class ExpressionEvaluator {
    private EvaluationContextProvider provider;
    private SqlIdentifierSanitizer sanitizer = SqlIdentifierSanitizer.words();

    public ExpressionEvaluator(EvaluationContextProvider provider) {
        this.provider = provider;
    }

    public String evaluate(Expression expression) throws EvaluationException {
        Assert.notNull((Object)expression, (String)"Expression must not be null.");
        String result = (String)expression.getValue(this.provider.getEvaluationContext(null), String.class);
        return this.sanitizer.sanitize(result);
    }

    public void setSanitizer(SqlIdentifierSanitizer sanitizer) {
        Assert.notNull((Object)sanitizer, (String)"SqlIdentifierSanitizer must not be null");
        this.sanitizer = sanitizer;
    }

    public void setProvider(EvaluationContextProvider provider) {
        this.provider = provider;
    }
}

