/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.AnsiDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class H2Dialect
extends AbstractDialect {
    @Deprecated(forRemoval=true)
    public static final H2Dialect INSTANCE = new H2Dialect();
    private static final IdentifierProcessing IDENTIFIER_PROCESSING = IdentifierProcessing.create(IdentifierProcessing.Quoting.ANSI, IdentifierProcessing.LetterCasing.UPPER_CASE);
    private static final IdGeneration ID_GENERATION = IdGeneration.create(IDENTIFIER_PROCESSING);
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };

    protected H2Dialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return AnsiDialect.LOCK_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return H2ArrayColumns.INSTANCE;
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IDENTIFIER_PROCESSING;
    }

    @Override
    public boolean supportsSingleQueryLoading() {
        return false;
    }

    @Override
    public IdGeneration getIdGeneration() {
        return ID_GENERATION;
    }

    protected static class H2ArrayColumns
    implements ArrayColumns {
        public static final H2ArrayColumns INSTANCE = new H2ArrayColumns();

        protected H2ArrayColumns() {
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public Class<?> getArrayType(Class<?> userType) {
            Assert.notNull(userType, (String)"Array component type must not be null");
            return ClassUtils.resolvePrimitiveIfNecessary(userType);
        }
    }
}

