/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.AnalyticFunction;
import org.springframework.data.relational.core.sql.OrderBy;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.OrderByClauseVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SegmentListVisitor;
import org.springframework.data.relational.core.sql.render.SimpleFunctionVisitor;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

class AnalyticFunctionVisitor
extends TypedSingleConditionRenderSupport<AnalyticFunction>
implements PartRenderer {
    private final StringBuilder part = new StringBuilder();
    private final RenderContext context;
    private @Nullable PartRenderer delegate;
    private boolean addSpace = false;

    AnalyticFunctionVisitor(RenderContext context) {
        super(context);
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof SimpleFunction) {
            this.delegate = new SimpleFunctionVisitor(this.context);
            return DelegatingVisitor.Delegation.delegateTo((DelegatingVisitor)((Object)this.delegate));
        }
        if (segment instanceof AnalyticFunction.Partition) {
            this.delegate = new SegmentListVisitor("PARTITION BY ", ", ", new ExpressionVisitor(this.context));
            return DelegatingVisitor.Delegation.delegateTo((DelegatingVisitor)((Object)this.delegate));
        }
        if (segment instanceof OrderBy) {
            this.delegate = new SegmentListVisitor("ORDER BY ", ", ", new OrderByClauseVisitor(this.context));
            return DelegatingVisitor.Delegation.delegateTo((DelegatingVisitor)((Object)this.delegate));
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        CharSequence renderedPart;
        if (this.delegate instanceof SimpleFunctionVisitor) {
            this.part.append(this.delegate.getRenderedPart());
            this.part.append(" OVER(");
        }
        if (this.delegate instanceof SegmentListVisitor && !(renderedPart = this.delegate.getRenderedPart()).isEmpty()) {
            if (this.addSpace) {
                this.part.append(' ');
            }
            this.part.append(renderedPart);
            this.addSpace = true;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(AnalyticFunction segment) {
        this.part.append(")");
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.part;
    }
}

