/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.InlineQuery;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.SubselectVisitor;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.util.Assert;

class FromTableVisitor
extends TypedSubtreeVisitor<TableLike> {
    private final RenderContext context;
    private final RenderTarget parent;
    private @Nullable StringBuilder builder = null;

    FromTableVisitor(RenderContext context, RenderTarget parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(TableLike segment) {
        this.builder = new StringBuilder();
        if (segment instanceof InlineQuery) {
            return DelegatingVisitor.Delegation.delegateTo(new SubselectVisitor(this.context, this.builder::append));
        }
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(TableLike segment) {
        Assert.state((this.builder != null ? 1 : 0) != 0, (String)"Builder must not be null in leaveMatched");
        this.builder.append(NameRenderer.render(this.context, segment));
        if (segment instanceof Aliased) {
            this.builder.append(" ").append(NameRenderer.render(this.context, (Aliased)((Object)segment)));
        }
        this.parent.onRendered(this.builder);
        return super.leaveMatched(segment);
    }
}

