/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;

class NameRenderer {
    static CharSequence render(RenderContext context, TableLike table) {
        return NameRenderer.render(context, context.getNamingStrategy().getName(table));
    }

    static CharSequence render(RenderContext context, Column column) {
        return NameRenderer.render(context, context.getNamingStrategy().getName(column));
    }

    static CharSequence render(RenderContext context, Named named) {
        return NameRenderer.render(context, named.getName());
    }

    static CharSequence render(RenderContext context, Aliased aliased) {
        return NameRenderer.render(context, aliased.getAlias());
    }

    static CharSequence reference(RenderContext context, TableLike table) {
        return NameRenderer.render(context, context.getNamingStrategy().getReferenceName(table));
    }

    static CharSequence reference(RenderContext context, Column column) {
        return NameRenderer.render(context, context.getNamingStrategy().getReferenceName(column));
    }

    static CharSequence fullyQualifiedReference(RenderContext context, Column column) {
        RenderNamingStrategy namingStrategy = context.getNamingStrategy();
        if (column instanceof Aliased) {
            return NameRenderer.render(context, namingStrategy.getReferenceName(column));
        }
        TableLike table = column.getRequiredTable();
        return NameRenderer.render(context, SqlIdentifier.from(namingStrategy.getReferenceName(table), namingStrategy.getReferenceName(column)));
    }

    static CharSequence fullyQualifiedUnaliasedReference(RenderContext context, Column column) {
        RenderNamingStrategy namingStrategy = context.getNamingStrategy();
        TableLike table = column.getRequiredTable();
        return NameRenderer.render(context, SqlIdentifier.from(namingStrategy.getReferenceName(table), namingStrategy.getName(column)));
    }

    static CharSequence render(RenderContext context, SqlIdentifier identifier) {
        return identifier.toSql(context.getIdentifierProcessing());
    }

    private NameRenderer() {
    }
}

