/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Not;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class NotConditionVisitor
extends TypedSubtreeVisitor<Not> {
    private final RenderContext context;
    private final RenderTarget target;
    private @Nullable ConditionVisitor conditionVisitor;

    NotConditionVisitor(RenderContext context, RenderTarget target) {
        this.context = context;
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        DelegatingVisitor visitor = this.getDelegation(segment);
        return visitor != null ? DelegatingVisitor.Delegation.delegateTo(visitor) : DelegatingVisitor.Delegation.retain();
    }

    private @Nullable DelegatingVisitor getDelegation(Visitable segment) {
        if (segment instanceof Condition) {
            this.conditionVisitor = new ConditionVisitor(this.context);
            return this.conditionVisitor;
        }
        return null;
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.conditionVisitor != null) {
            this.target.onRendered("NOT " + String.valueOf(this.conditionVisitor.getRenderedPart()));
            this.conditionVisitor = null;
        }
        return super.leaveNested(segment);
    }
}

