/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.halexplorer;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;

@BasePathAwareController
class HalExplorer {
    static final String EXPLORER = "/explorer";
    static final String INDEX = "/index.html";

    HalExplorer() {
    }

    @GetMapping(value={"/", ""}, produces={"text/html"})
    View index(HttpServletRequest request) {
        return this.getRedirectView(request, false);
    }

    @GetMapping(value={"/explorer"})
    public View explorer(HttpServletRequest request) {
        return this.getRedirectView(request, request.getRequestURI().endsWith(EXPLORER));
    }

    private View getRedirectView(HttpServletRequest request, boolean explorerRelative) {
        String path;
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        UriComponents components = builder.build();
        String string = path = components.getPath() == null ? "" : components.getPath();
        if (!explorerRelative) {
            builder.path(EXPLORER);
        }
        builder.path(INDEX);
        builder.fragment(String.format("uri=%s", explorerRelative ? path.substring(0, path.lastIndexOf(EXPLORER)) : path));
        return new RedirectView(builder.build().toUriString());
    }
}

