/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.web.util.UriComponentsBuilder;

public class PagingAndSorting
implements Pageable {
    private final RepositoryRestConfiguration config;
    private final PageRequest pageRequest;

    public PagingAndSorting(RepositoryRestConfiguration config, PageRequest pageRequest) {
        this.config = config;
        this.pageRequest = pageRequest;
    }

    public PagingAndSorting addSortParameters(UriComponentsBuilder urib) {
        Sort sort = this.pageRequest.getSort();
        if (null != sort) {
            for (Sort.Order order : sort) {
                urib.queryParam(this.config.getSortParamName(), new Object[]{order.getProperty()});
                try {
                    urib.queryParam(URLEncoder.encode(order.getProperty() + ".dir", "ISO-8859-1"), new Object[]{order.getDirection().toString().toLowerCase()});
                }
                catch (UnsupportedEncodingException ignored) {}
            }
        }
        return this;
    }

    public int getPageNumber() {
        return this.pageRequest.getPageNumber();
    }

    public int getPageSize() {
        return this.pageRequest.getPageSize();
    }

    public int getOffset() {
        return this.pageRequest.getOffset();
    }

    public Sort getSort() {
        return this.pageRequest.getSort();
    }
}

