/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.repository.BaseUriAwareResource;
import org.springframework.hateoas.Link;

public class PersistentEntityResource<T>
extends BaseUriAwareResource<T> {
    @JsonIgnore
    private final PersistentEntity<T, ?> persistentEntity;

    public static <T> PersistentEntityResource<T> wrap(PersistentEntity persistentEntity, T obj, URI baseUri) {
        PersistentEntityResource<T> resource = new PersistentEntityResource<T>(persistentEntity, obj, new Link[0]);
        resource.setBaseUri(baseUri);
        return resource;
    }

    public PersistentEntityResource(PersistentEntity<T, ?> persistentEntity) {
        this.persistentEntity = persistentEntity;
    }

    public PersistentEntityResource(PersistentEntity<T, ?> persistentEntity, T content, Link ... links) {
        super(content, links);
        this.persistentEntity = persistentEntity;
    }

    public PersistentEntityResource(PersistentEntity<T, ?> persistentEntity, T content, Iterable<Link> links) {
        super(content, links);
        this.persistentEntity = persistentEntity;
    }

    public PersistentEntity<T, ?> getPersistentEntity() {
        return this.persistentEntity;
    }
}

