/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.rest.repository.support.RepositoryInformationSupport;

public class UriDomainClassConverter
extends RepositoryInformationSupport
implements ConditionalGenericConverter,
InitializingBean {
    private static TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    @Autowired
    private DomainClassConverter domainClassConverter;
    private Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();

    public void afterPropertiesSet() throws Exception {
        for (Class domainType : this.repositories) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, domainType));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return URI.class.isAssignableFrom(sourceType.getType()) && null != this.repositories.getPersistentEntity(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity entity = this.repositories.getPersistentEntity(targetType.getType());
        if (null == entity || !this.domainClassConverter.matches(STRING_TYPE, targetType)) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("No PersistentEntity information available for " + targetType.getType()));
        }
        URI uri = (URI)source;
        String[] parts = uri.getPath().split("/");
        if (parts.length < 2) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("Cannot resolve URI " + uri + ". Is it local or remote? Only local URIs are resolvable."));
        }
        return this.domainClassConverter.convert((Object)parts[parts.length - 1], STRING_TYPE, targetType);
    }
}

