/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.repository.invoke.RepositoryMethod;
import org.springframework.util.ReflectionUtils;

public class RepositoryMethodInvoker
implements PagingAndSortingRepository<Object, Serializable> {
    private final Object repository;
    private final Map<String, RepositoryMethod> queryMethods = new HashMap<String, RepositoryMethod>();
    private RepositoryMethod saveOne;
    private RepositoryMethod saveSome;
    private RepositoryMethod findOne;
    private RepositoryMethod exists;
    private RepositoryMethod findAll;
    private RepositoryMethod findAllSorted;
    private RepositoryMethod findAllPaged;
    private RepositoryMethod findSome;
    private RepositoryMethod count;
    private RepositoryMethod deleteOne;
    private RepositoryMethod deleteOneById;
    private RepositoryMethod deleteSome;
    private RepositoryMethod deleteAll;

    public RepositoryMethodInvoker(Object repository, RepositoryInformation repoInfo, PersistentEntity persistentEntity) {
        this.repository = repository;
        Class repoType = repoInfo.getRepositoryInterface();
        ReflectionUtils.doWithMethods((Class)repoType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String name = method.getName();
                int cardinality = method.getParameterTypes().length;
                Class<?> paramType = cardinality == 1 ? method.getParameterTypes()[0] : null;
                boolean someMethod = null != paramType && Iterable.class.isAssignableFrom(paramType);
                boolean byIdMethod = null != paramType && paramType == Serializable.class;
                boolean sortable = null != paramType && Sort.class.isAssignableFrom(paramType);
                boolean pageable = null != paramType && Pageable.class.isAssignableFrom(paramType);
                RepositoryMethod repoMethod = new RepositoryMethod(method);
                if ("save".equals(name) && someMethod) {
                    RepositoryMethodInvoker.this.saveSome = repoMethod;
                } else if ("save".equals(name)) {
                    RepositoryMethodInvoker.this.saveOne = repoMethod;
                } else if ("findOne".equals(name)) {
                    RepositoryMethodInvoker.this.findOne = repoMethod;
                } else if ("exists".equals(name)) {
                    RepositoryMethodInvoker.this.exists = repoMethod;
                } else if ("findAll".equals(name) && someMethod) {
                    RepositoryMethodInvoker.this.findSome = repoMethod;
                } else if ("findAll".equals(name) && sortable) {
                    RepositoryMethodInvoker.this.findAllSorted = repoMethod;
                } else if ("findAll".equals(name) && pageable) {
                    RepositoryMethodInvoker.this.findAllPaged = repoMethod;
                } else if ("findAll".equals(name)) {
                    RepositoryMethodInvoker.this.findAll = repoMethod;
                } else if ("count".equals(name)) {
                    RepositoryMethodInvoker.this.count = repoMethod;
                } else if ("delete".equals(name) && byIdMethod) {
                    RepositoryMethodInvoker.this.deleteOneById = repoMethod;
                } else if ("delete".equals(name) && someMethod) {
                    RepositoryMethodInvoker.this.deleteSome = repoMethod;
                } else if ("delete".equals(name)) {
                    RepositoryMethodInvoker.this.deleteOne = repoMethod;
                } else if ("deleteAll".equals(name)) {
                    RepositoryMethodInvoker.this.deleteAll = repoMethod;
                } else {
                    RepositoryMethodInvoker.this.queryMethods.put(name, repoMethod);
                }
            }
        });
    }

    public <S> S save(S entity) {
        return (S)ReflectionUtils.invokeMethod((Method)this.saveOne.getMethod(), (Object)this.repository, (Object[])new Object[]{entity});
    }

    public boolean hasSaveOne() {
        return null != this.saveOne;
    }

    public <S> Iterable<S> save(Iterable<S> entities) {
        return (Iterable)ReflectionUtils.invokeMethod((Method)this.saveSome.getMethod(), (Object)this.repository, (Object[])new Object[]{entities});
    }

    public boolean hasSaveSome() {
        return null != this.saveSome;
    }

    public Object findOne(Serializable serializable) {
        return ReflectionUtils.invokeMethod((Method)this.findOne.getMethod(), (Object)this.repository, (Object[])new Object[]{serializable});
    }

    public boolean hasFindOne() {
        return null != this.findOne;
    }

    public boolean exists(Serializable serializable) {
        return (Boolean)ReflectionUtils.invokeMethod((Method)this.exists.getMethod(), (Object)this.repository, (Object[])new Object[]{serializable});
    }

    public boolean hasExists() {
        return null != this.exists;
    }

    public Iterable<Object> findAll() {
        return (Iterable)ReflectionUtils.invokeMethod((Method)this.findAll.getMethod(), (Object)this.repository);
    }

    public boolean hasFindAll() {
        return null != this.findAll;
    }

    public Iterable<Object> findAll(Iterable<Serializable> serializables) {
        return (Iterable)ReflectionUtils.invokeMethod((Method)this.findSome.getMethod(), (Object)this.repository, (Object[])new Object[]{serializables});
    }

    public boolean hasFindSome() {
        return null != this.findSome;
    }

    public Iterable<Object> findAll(Sort sort) {
        return (Iterable)ReflectionUtils.invokeMethod((Method)this.findAllSorted.getMethod(), (Object)this.repository, (Object[])new Object[]{sort});
    }

    public boolean hasFindAllSorted() {
        return null != this.findAllSorted;
    }

    public Page<Object> findAll(Pageable pageable) {
        return (Page)ReflectionUtils.invokeMethod((Method)this.findAllPaged.getMethod(), (Object)this.repository, (Object[])new Object[]{pageable});
    }

    public boolean hasFindAllPageable() {
        return null != this.findAllPaged;
    }

    public void delete(Serializable serializable) {
        ReflectionUtils.invokeMethod((Method)this.deleteOneById.getMethod(), (Object)this.repository, (Object[])new Object[]{serializable});
    }

    public boolean hasDeleteOneById() {
        return null != this.deleteOneById;
    }

    public long count() {
        return (Long)ReflectionUtils.invokeMethod((Method)this.count.getMethod(), (Object)this.repository);
    }

    public boolean hasCount() {
        return null != this.count;
    }

    public void delete(Object entity) {
        ReflectionUtils.invokeMethod((Method)this.deleteOne.getMethod(), (Object)this.repository, (Object[])new Object[]{entity});
    }

    public boolean hasDeleteOne() {
        return null != this.deleteOne;
    }

    public void delete(Iterable<?> entities) {
        ReflectionUtils.invokeMethod((Method)this.deleteSome.getMethod(), (Object)this.repository, (Object[])new Object[]{entities});
    }

    public boolean hasDeleteSome() {
        return null != this.deleteSome;
    }

    public void deleteAll() {
        ReflectionUtils.invokeMethod((Method)this.deleteAll.getMethod(), (Object)this.repository);
    }

    public boolean hasDeleteAll() {
        return null != this.deleteAll;
    }

    public Map<String, RepositoryMethod> getQueryMethods() {
        return this.queryMethods;
    }

    public RepositoryMethod getRepositoryMethod(String name) {
        return this.queryMethods.get(name);
    }

    public Object invokeQueryMethod(String name, Object ... params) {
        RepositoryMethod repoMethod = this.queryMethods.get(name);
        if (null == repoMethod) {
            throw new NoSuchMethodError(name);
        }
        return ReflectionUtils.invokeMethod((Method)repoMethod.getMethod(), (Object)this.repository, (Object[])params);
    }

    public Object invokeQueryMethod(RepositoryMethod method, Object ... params) {
        return ReflectionUtils.invokeMethod((Method)method.getMethod(), (Object)this.repository, (Object[])params);
    }
}

