/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.util.Assert;

public class RepositoryQueryMethod {
    private Method method;
    private Class<?>[] paramTypes;
    private String[] paramNames;

    public RepositoryQueryMethod(Method method) {
        this.method = method;
        this.paramTypes = method.getParameterTypes();
        this.paramNames = new String[this.paramTypes.length];
        if (null == this.paramNames) {
            this.paramNames = new String[this.paramTypes.length];
        }
        Annotation[][] paramAnnos = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnos.length; ++i) {
            if (paramAnnos[i].length == 0) continue;
            for (Annotation anno : paramAnnos[i]) {
                if (!Param.class.isAssignableFrom(anno.getClass())) continue;
                Param p = (Param)anno;
                this.paramNames[i] = p.value();
                break;
            }
            if (Pageable.class.isAssignableFrom(this.paramTypes[i]) || Sort.class.isAssignableFrom(this.paramTypes[i])) continue;
            Assert.notNull((Object)this.paramNames[i], (String)("No @Param('name') was provided for parameter " + (i + 1) + " of type " + this.paramTypes[i] + " on " + method.getDeclaringClass().getName() + "." + method.getName()));
        }
    }

    public Class<?>[] paramTypes() {
        return this.paramTypes;
    }

    public String[] paramNames() {
        return this.paramNames;
    }

    public Method method() {
        return this.method;
    }
}

