package org.springframework.data.rest.webmvc;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.data.rest.webmvc.json.JsonSchemaController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

/**
 * {@link RequestMappingHandlerAdapter} implementation that adds a couple argument resolvers for controller method
 * parameters used in the REST exporter controller. Also only looks for handler methods in the {@link
 * RepositoryRestController} class to help isolate this handler adapter from other handler adapters the user might have
 * configured in their Spring MVC context.
 *
 * @author Jon Brisbin
 */
public class RepositoryRestHandlerAdapter extends ResourceProcessorInvokingHandlerAdapter {

  @Autowired
  private List<HandlerMethodArgumentResolver> argumentResolvers;

  @Override public void afterPropertiesSet() {
    setCustomArgumentResolvers(argumentResolvers);
    super.afterPropertiesSet();
  }

  @Override public int getOrder() {
    return Ordered.HIGHEST_PRECEDENCE;
  }

  @Override protected boolean supportsInternal(HandlerMethod handlerMethod) {
    return super.supportsInternal(handlerMethod)
        && (RepositoryRestController.class.isAssignableFrom(handlerMethod.getBeanType())
        || JsonSchemaController.class.isAssignableFrom(handlerMethod.getBeanType()));
  }

}
