/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;

public class EntityResource
extends Resource<Map<String, Object>> {
    public EntityResource(Map<String, Object> dto, Set<Link> links) {
        super(dto, links);
    }

    public static EntityResource wrap(Object entity, RepositoryMetadata repoMeta, URI baseUri) {
        HashSet<Link> links = new HashSet<Link>();
        for (Object attrName : repoMeta.entityMetadata().linkedAttributes().keySet()) {
            URI uri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{attrName.toString()});
            String rel = repoMeta.rel() + "." + entity.getClass().getSimpleName() + "." + attrName;
            links.add(new Link(uri.toString(), rel));
        }
        links.add(new Link(baseUri.toString(), "self"));
        HashMap<String, Object> entityDto = new HashMap<String, Object>();
        for (Map.Entry attrMeta : repoMeta.entityMetadata().embeddedAttributes().entrySet()) {
            String name = (String)attrMeta.getKey();
            Object val = ((AttributeMetadata)attrMeta.getValue()).get(entity);
            if (null == val) continue;
            entityDto.put(name, val);
        }
        return new EntityResource(entityDto, links);
    }

    @JsonAnyGetter
    public Map<String, Object> getContent() {
        return (Map)super.getContent();
    }
}

