/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.RepositoryConstraintViolationException;
import org.springframework.data.rest.repository.invoke.MethodParameterConversionService;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.support.BaseUriLinkBuilder;
import org.springframework.data.rest.webmvc.support.ExceptionMessage;
import org.springframework.data.rest.webmvc.support.RepositoryConstraintViolationExceptionMessage;
import org.springframework.data.rest.webmvc.support.ValidationExceptionHandler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class AbstractRepositoryRestController
implements ApplicationContextAware {
    static final Resource<?> EMPTY_RESOURCE = new Resource(Collections.emptyList(), new Link[0]);
    static final Resources<Resource<?>> EMPTY_RESOURCES = new Resources(Collections.emptyList(), new Link[0]);
    static final Iterable<Resource<?>> EMPTY_RESOURCE_LIST = Collections.emptyList();
    static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final Repositories repositories;
    protected final RepositoryRestConfiguration config;
    protected final DomainClassConverter domainClassConverter;
    protected final ConversionService conversionService;
    protected final MethodParameterConversionService methodParameterConversionService;
    protected final EntityLinks entityLinks;
    protected ApplicationContext applicationContext;
    @Autowired(required=false)
    protected ValidationExceptionHandler handler;

    @Autowired
    public AbstractRepositoryRestController(Repositories repositories, RepositoryRestConfiguration config, DomainClassConverter domainClassConverter, ConversionService conversionService, EntityLinks entityLinks) {
        this.repositories = repositories;
        this.config = config;
        this.domainClassConverter = domainClassConverter;
        this.conversionService = conversionService;
        this.entityLinks = entityLinks;
        this.methodParameterConversionService = new MethodParameterConversionService(conversionService);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ResponseEntity<?> handleNPE(NullPointerException npe) {
        return this.errorResponse(npe, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseBody
    public ResponseEntity<?> handleNotFound() {
        return this.notFound();
    }

    @ExceptionHandler(value={NoSuchMethodError.class, HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseEntity<?> handleNoSuchMethod() {
        return this.errorResponse(null, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, HttpMessageNotWritableException.class})
    @ResponseBody
    public ResponseEntity<ExceptionMessage> handleNotReadable(HttpMessageNotReadableException e) {
        return this.badRequest(e);
    }

    @ExceptionHandler(value={InvocationTargetException.class, IllegalArgumentException.class, ClassCastException.class, ConversionFailedException.class})
    @ResponseBody
    public ResponseEntity handleMiscFailures(Throwable t) {
        if (null != t.getCause() && t.getCause() instanceof ResourceNotFoundException) {
            return this.notFound();
        }
        return this.badRequest(t);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ResponseEntity maybeHandleValidationException(Locale locale, RuntimeException ex) {
        if (ResourceNotFoundException.class.isAssignableFrom(ex.getClass())) {
            return this.handleNotFound();
        }
        if (null != this.handler) {
            return this.handler.handleValidationException(ex, (MessageSource)this.applicationContext, locale);
        }
        return this.response(null, ex, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={RepositoryConstraintViolationException.class})
    @ResponseBody
    public ResponseEntity handleRepositoryConstraintViolationException(Locale locale, RepositoryConstraintViolationException rcve) {
        return this.response(null, new RepositoryConstraintViolationExceptionMessage(rcve, (MessageSource)this.applicationContext, locale), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class, DataIntegrityViolationException.class})
    @ResponseBody
    public ResponseEntity handleConflict(Exception ex) {
        return this.errorResponse(null, ex, HttpStatus.CONFLICT);
    }

    protected <T> ResponseEntity<T> notFound() {
        return this.notFound(null, null);
    }

    protected <T> ResponseEntity<T> notFound(HttpHeaders headers, T body) {
        return this.response(headers, body, HttpStatus.NOT_FOUND);
    }

    protected <T extends Throwable> ResponseEntity<ExceptionMessage> badRequest(T throwable) {
        return this.badRequest(null, throwable);
    }

    protected <T extends Throwable> ResponseEntity<ExceptionMessage> badRequest(HttpHeaders headers, T throwable) {
        return this.errorResponse(headers, throwable, HttpStatus.BAD_REQUEST);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> internalServerError(T throwable) {
        return this.internalServerError(null, throwable);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> internalServerError(HttpHeaders headers, T throwable) {
        return this.errorResponse(headers, throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> errorResponse(T throwable, HttpStatus status) {
        return this.errorResponse(null, throwable, status);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> errorResponse(HttpHeaders headers, T throwable, HttpStatus status) {
        this.LOG.error(throwable.getMessage(), throwable);
        return this.response(headers, new ExceptionMessage(throwable), status);
    }

    public <T> ResponseEntity<T> response(HttpHeaders headers, T body, HttpStatus status) {
        HttpHeaders hdrs = new HttpHeaders();
        if (null != headers) {
            hdrs.putAll((Map)headers);
        }
        return new ResponseEntity(body, (MultiValueMap)hdrs, status);
    }

    public <R extends Resource<?>> ResponseEntity<Resource<?>> resourceResponse(HttpHeaders headers, R resource, HttpStatus status) {
        HttpHeaders hdrs = new HttpHeaders();
        if (null != headers) {
            hdrs.putAll((Map)headers);
        }
        return new ResponseEntity(resource, (MultiValueMap)hdrs, status);
    }

    protected List<Link> queryMethodLinks(URI baseUri, Class<?> domainType) {
        ArrayList<Link> links = new ArrayList<Link>();
        RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(domainType);
        ResourceMapping repoMapping = ResourceMappingUtils.merge((Class)repoInfo.getRepositoryInterface(), (ResourceMapping)this.config.getResourceMappingForRepository(repoInfo.getRepositoryInterface()));
        for (Method method : repoInfo.getQueryMethods()) {
            BaseUriLinkBuilder linkBuilder = BaseUriLinkBuilder.create(UriUtils.buildUri((URI)baseUri, (String[])new String[]{repoMapping.getPath(), "search"}));
            ResourceMapping methodMapping = ResourceMappingUtils.merge((Method)method, (ResourceMapping)repoMapping.getResourceMappingFor(method.getName()));
            links.add(linkBuilder.slash(methodMapping.getPath()).withRel(repoMapping.getRel() + "." + methodMapping.getRel()));
        }
        return links;
    }

    protected Link resourceLink(RepositoryRestRequest repoRequest, Resource resource) {
        ResourceMapping repoMapping = repoRequest.getRepositoryResourceMapping();
        ResourceMapping entityMapping = repoRequest.getPersistentEntityResourceMapping();
        Link selfLink = resource.getLink("self");
        String rel = repoMapping.getRel() + "." + entityMapping.getRel();
        return new Link(selfLink.getHref(), rel);
    }
}

