/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.repository.PersistentEntityResource;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.RepositoryRestRequestHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Autowired
    private RepositoryRestRequestHandlerMethodArgumentResolver repoRequestResolver;
    private final List<HttpMessageConverter<?>> messageConverters;

    public PersistentEntityResourceHandlerMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResource.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RepositoryRestRequest repoRequest = (RepositoryRestRequest)this.repoRequestResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        ServletServerHttpRequest request = new ServletServerHttpRequest((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            Class domainType;
            if (!converter.canRead(domainType = repoRequest.getPersistentEntity().getType(), request.getHeaders().getContentType())) continue;
            Object obj = converter.read(domainType, (HttpInputMessage)request);
            return new PersistentEntityResource(repoRequest.getPersistentEntity(), obj, new Link[0]);
        }
        return null;
    }
}

