/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class RepositoryController
extends AbstractRepositoryRestController {
    @Autowired
    public RepositoryController(Repositories repositories, RepositoryRestConfiguration config, DomainClassConverter domainClassConverter, ConversionService conversionService, EntityLinks entityLinks) {
        super(repositories, config, domainClassConverter, conversionService, entityLinks);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-compact+json"})
    @ResponseBody
    public Resource<?> listRepositories() throws ResourceNotFoundException {
        Resource links = new Resource(Collections.emptyList(), new Link[0]);
        for (Class domainType : this.repositories) {
            ResourceMapping repoMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (RepositoryInformation)this.repositories.getRepositoryInformationFor(domainType));
            if (!repoMapping.isExported()) continue;
            links.add(this.entityLinks.linkToCollectionResource(domainType));
        }
        return links;
    }
}

