/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.support.ExceptionMessage;
import org.springframework.data.rest.webmvc.support.RepositoryConstraintViolationExceptionMessage;
import org.springframework.data.rest.webmvc.support.ValidationExceptionHandler;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

class AbstractRepositoryRestController
implements MessageSourceAware,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRepositoryRestController.class);
    private final PersistentEntityResourceAssembler<Object> perAssembler;
    @Autowired(required=false)
    private ValidationExceptionHandler handler;
    @Autowired(required=false)
    private PlatformTransactionManager txMgr;
    private MessageSource messageSource;
    private PagedResourcesAssembler<Object> assembler;

    public AbstractRepositoryRestController(PagedResourcesAssembler<Object> assembler, PersistentEntityResourceAssembler<Object> entityResourceAssembler) {
        this.assembler = assembler;
        this.perAssembler = entityResourceAssembler;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void afterPropertiesSet() throws Exception {
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ResponseEntity<?> handleNPE(NullPointerException npe) {
        return this.errorResponse(npe, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseBody
    public ResponseEntity<?> handleNotFound() {
        return this.notFound();
    }

    @ExceptionHandler(value={NoSuchMethodError.class, HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseEntity<?> handleNoSuchMethod() {
        return this.errorResponse(null, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, HttpMessageNotWritableException.class})
    @ResponseBody
    public ResponseEntity<ExceptionMessage> handleNotReadable(HttpMessageNotReadableException e) {
        return this.badRequest(e);
    }

    @ExceptionHandler(value={InvocationTargetException.class, IllegalArgumentException.class, ClassCastException.class, ConversionFailedException.class})
    @ResponseBody
    public ResponseEntity handleMiscFailures(Throwable t) {
        if (null != t.getCause() && t.getCause() instanceof ResourceNotFoundException) {
            return this.notFound();
        }
        return this.badRequest(t);
    }

    @ExceptionHandler(value={RepositoryConstraintViolationException.class})
    @ResponseBody
    public ResponseEntity handleRepositoryConstraintViolationException(Locale locale, RepositoryConstraintViolationException rcve) {
        return this.response(null, new RepositoryConstraintViolationExceptionMessage(rcve, this.messageSource, locale), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class, DataIntegrityViolationException.class})
    @ResponseBody
    public ResponseEntity handleConflict(Exception ex) {
        return this.errorResponse(null, ex, HttpStatus.CONFLICT);
    }

    protected <T> ResponseEntity<T> notFound() {
        return this.notFound(null, null);
    }

    protected <T> ResponseEntity<T> notFound(HttpHeaders headers, T body) {
        return this.response(headers, body, HttpStatus.NOT_FOUND);
    }

    protected <T extends Throwable> ResponseEntity<ExceptionMessage> badRequest(T throwable) {
        return this.badRequest(null, throwable);
    }

    protected <T extends Throwable> ResponseEntity<ExceptionMessage> badRequest(HttpHeaders headers, T throwable) {
        return this.errorResponse(headers, throwable, HttpStatus.BAD_REQUEST);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> errorResponse(T throwable, HttpStatus status) {
        return this.errorResponse(null, throwable, status);
    }

    public <T extends Throwable> ResponseEntity<ExceptionMessage> errorResponse(HttpHeaders headers, T throwable, HttpStatus status) {
        if (null != throwable && null != throwable.getMessage()) {
            LOG.error(throwable.getMessage(), throwable);
            return this.response(headers, new ExceptionMessage(throwable), status);
        }
        return this.response(headers, null, status);
    }

    public <T> ResponseEntity<T> response(HttpHeaders headers, T body, HttpStatus status) {
        HttpHeaders hdrs = new HttpHeaders();
        if (null != headers) {
            hdrs.putAll((Map)headers);
        }
        return new ResponseEntity(body, (MultiValueMap)hdrs, status);
    }

    protected Link resourceLink(RepositoryRestRequest repoRequest, Resource resource) {
        ResourceMetadata repoMapping = repoRequest.getResourceMetadata();
        Link selfLink = resource.getLink("self");
        String rel = repoMapping.getItemResourceRel();
        return new Link(selfLink.getHref(), rel);
    }

    protected Resources resultToResources(Object result) {
        if (result instanceof Page) {
            Page page = (Page)result;
            return this.entitiesToResources((Page<Object>)page, this.assembler);
        }
        if (result instanceof Iterable) {
            return this.entitiesToResources((Iterable)result);
        }
        if (null == result) {
            return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]);
        }
        PersistentEntityResource<Object> resource = this.perAssembler.toResource(result);
        return new Resources(Collections.singletonList(resource), new Link[0]);
    }

    protected Resources<? extends Resource<Object>> entitiesToResources(Page<Object> page, PagedResourcesAssembler<Object> assembler) {
        return assembler.toResource(page, this.perAssembler);
    }

    protected Resources<Resource<Object>> entitiesToResources(Iterable<Object> entities) {
        ArrayList<PersistentEntityResource<Object>> resources = new ArrayList<PersistentEntityResource<Object>>();
        for (Object obj : entities) {
            resources.add(obj == null ? null : this.perAssembler.toResource(obj));
        }
        return new Resources(resources, new Link[0]);
    }
}

