/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class ControllerUtils {
    public static final Resources<Resource<?>> EMPTY_RESOURCES = new Resources(Collections.emptyList(), new Link[0]);
    public static final Iterable<Resource<?>> EMPTY_RESOURCE_LIST = Collections.emptyList();
    public static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);

    public static <R extends ResourceSupport> ResponseEntity<ResourceSupport> toResponseEntity(HttpStatus status, HttpHeaders headers, R resource) {
        HttpHeaders hdrs = new HttpHeaders();
        if (null != headers) {
            hdrs.putAll((Map)headers);
        }
        return new ResponseEntity(resource, (MultiValueMap)hdrs, status);
    }

    public static ResponseEntity<ResourceSupport> toEmptyResponse(HttpStatus status) {
        return ControllerUtils.toResponseEntity(status, null, EMPTY_RESOURCES);
    }

    public static ResponseEntity<ResourceSupport> toEmptyResponse(HttpStatus status, HttpHeaders headers) {
        return ControllerUtils.toResponseEntity(status, headers, EMPTY_RESOURCES);
    }
}

