/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import javax.servlet.http.HttpServletRequest;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.NativeWebRequest;

class RepositoryRestRequest {
    private final NativeWebRequest request;
    private final ResourceMetadata resourceMetadata;
    private final RepositoryInvoker repoInvoker;
    private final PersistentEntity<?, ?> persistentEntity;

    public RepositoryRestRequest(PersistentEntity<?, ?> entity, NativeWebRequest request, ResourceMetadata repoInfo, RepositoryInvoker invoker) {
        this.request = request;
        this.resourceMetadata = repoInfo;
        if (this.resourceMetadata == null || !this.resourceMetadata.isExported()) {
            this.repoInvoker = null;
            this.persistentEntity = null;
        } else {
            this.repoInvoker = invoker;
            this.persistentEntity = entity;
        }
    }

    NativeWebRequest getRequest() {
        return this.request;
    }

    HttpMethod getRequestMethod() {
        return HttpMethod.valueOf((String)((HttpServletRequest)this.request.getNativeRequest(HttpServletRequest.class)).getMethod());
    }

    Class<?> getDomainType() {
        return this.resourceMetadata.getDomainType();
    }

    ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    SearchResourceMappings getSearchMappings() {
        return this.resourceMetadata.getSearchResourceMappings();
    }

    RepositoryInvoker getRepositoryInvoker() {
        return this.repoInvoker;
    }

    PersistentEntity<?, ?> getPersistentEntity() {
        return this.persistentEntity;
    }
}

