/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.core.MethodParameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.invoke.RepositoryInvokerFactory;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepositoryRestRequestHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final RepositoryInvokerFactory invokerFactory;
    private final ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver;

    public RepositoryRestRequestHandlerMethodArgumentResolver(Repositories repositories, RepositoryInvokerFactory invokerFactory, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)invokerFactory, (String)"invokerFactory must not be null!");
        Assert.notNull((Object)resourceMetadataResolver, (String)"ResourceMetadataHandlerMethodArgumentResolver must not be null!");
        this.repositories = repositories;
        this.invokerFactory = invokerFactory;
        this.resourceMetadataResolver = resourceMetadataResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RepositoryRestRequest.class.isAssignableFrom(parameter.getParameterType());
    }

    public RepositoryRestRequest resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        ResourceMetadata repoInfo = this.resourceMetadataResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        RepositoryInvoker repositoryInvoker = this.invokerFactory.getInvokerFor(repoInfo.getDomainType());
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(repoInfo.getDomainType());
        return new RepositoryRestRequest(persistentEntity, webRequest, repoInfo, repositoryInvoker);
    }
}

