/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.HeaderLinksResponseEntity;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResourceProcessorHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final TypeInformation<?> RESOURCE_TYPE = ClassTypeInformation.from(Resource.class);
    private static final TypeInformation<?> RESOURCES_TYPE = ClassTypeInformation.from(Resources.class);
    private static final Field CONTENT_FIELD = ReflectionUtils.findField(Resources.class, (String)"content");
    private final HandlerMethodReturnValueHandler delegate;
    private final List<ProcessorWrapper> processors;
    private boolean rootLinksAsHeaders = false;

    public ResourceProcessorHandlerMethodReturnValueHandler(HandlerMethodReturnValueHandler delegate, List<ResourceProcessor<?>> processors) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null!");
        Assert.notNull(processors, (String)"ResourceProcessors must not be null!");
        this.delegate = delegate;
        this.processors = new ArrayList<ProcessorWrapper>();
        for (ResourceProcessor<?> processor : processors) {
            TypeInformation componentType = ClassTypeInformation.from(processor.getClass()).getSuperTypeInformation(ResourceProcessor.class).getComponentType();
            Class rawType = componentType.getType();
            if (Resource.class.isAssignableFrom(rawType)) {
                this.processors.add(new ResourceProcessorWrapper(processor));
                continue;
            }
            if (Resources.class.isAssignableFrom(rawType)) {
                this.processors.add(new ResourcesProcessorWrapper(processor));
                continue;
            }
            this.processors.add(new DefaultProcessorWrapper(processor));
        }
        Collections.sort(this.processors, AnnotationAwareOrderComparator.INSTANCE);
    }

    public void setRootLinksAsHeaders(boolean rootLinksAsHeaders) {
        this.rootLinksAsHeaders = rootLinksAsHeaders;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object value = returnValue;
        if (returnValue instanceof HttpEntity) {
            value = ((HttpEntity)returnValue).getBody();
        }
        if (!this.isResourceType(value)) {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
            return;
        }
        TypeInformation targetType = ClassTypeInformation.fromReturnTypeOf((Method)returnType.getMethod());
        if (HttpEntity.class.isAssignableFrom(targetType.getType())) {
            targetType = (TypeInformation)targetType.getTypeArguments().get(0);
        }
        TypeInformation returnValueTypeInformation = ClassTypeInformation.from(value.getClass());
        if (!targetType.getType().equals(returnValueTypeInformation.getType())) {
            targetType = returnValueTypeInformation;
        }
        if (RESOURCES_TYPE.isAssignableFrom(targetType)) {
            Resources resources = (Resources)value;
            TypeInformation elementTargetType = targetType.getSuperTypeInformation(Resources.class).getComponentType();
            ArrayList<Object> result = new ArrayList<Object>(resources.getContent().size());
            for (Object element : resources) {
                TypeInformation elementTypeInformation = ClassTypeInformation.from(element.getClass());
                if (!elementTargetType.getType().equals(elementTypeInformation.getType())) {
                    elementTargetType = elementTypeInformation;
                }
                result.add(this.invokeProcessorsFor(element, elementTargetType));
            }
            ReflectionUtils.setField((Field)CONTENT_FIELD, (Object)resources, result);
        }
        ResourceSupport result = (ResourceSupport)this.invokeProcessorsFor(value, targetType);
        this.delegate.handleReturnValue(this.rewrapResult(result, returnValue), returnType, mavContainer, webRequest);
    }

    private Object invokeProcessorsFor(Object value, TypeInformation<?> targetType) {
        Object currentValue = value;
        for (ProcessorWrapper wrapper : this.processors) {
            if (!wrapper.supports(targetType, currentValue)) continue;
            currentValue = wrapper.invokeProcessor(currentValue);
        }
        return currentValue;
    }

    Object rewrapResult(ResourceSupport newBody, Object originalValue) {
        if (!(originalValue instanceof HttpEntity)) {
            return newBody;
        }
        HttpEntity entity = null;
        if (originalValue instanceof ResponseEntity) {
            ResponseEntity source = (ResponseEntity)originalValue;
            entity = new ResponseEntity((Object)newBody, (MultiValueMap)source.getHeaders(), source.getStatusCode());
        } else {
            HttpEntity source = (HttpEntity)originalValue;
            entity = new HttpEntity((Object)newBody, (MultiValueMap)source.getHeaders());
        }
        return this.addLinksToHeaderWrapper((HttpEntity<ResourceSupport>)entity);
    }

    private HttpEntity<?> addLinksToHeaderWrapper(HttpEntity<ResourceSupport> entity) {
        return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(entity) : entity;
    }

    private boolean isResourceType(Object value) {
        return value instanceof ResourceSupport;
    }

    static {
        ReflectionUtils.makeAccessible((Field)CONTENT_FIELD);
    }

    private static class CustomOrderAwareComparator
    extends AnnotationAwareOrderComparator {
        public static CustomOrderAwareComparator INSTANCE = new CustomOrderAwareComparator();

        private CustomOrderAwareComparator() {
        }

        protected int getOrder(Object obj) {
            return super.getOrder(obj);
        }
    }

    private static class ResourcesProcessorWrapper
    extends DefaultProcessorWrapper {
        public ResourcesProcessorWrapper(ResourceProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(TypeInformation<?> typeInformation, Object value) {
            if (!RESOURCES_TYPE.isAssignableFrom(typeInformation)) {
                return false;
            }
            return super.supports(typeInformation, value) || ResourcesProcessorWrapper.isValueTypeMatch((Resources)value, this.getTargetType());
        }

        private static boolean isValueTypeMatch(Resources<?> resources, TypeInformation<?> target) {
            if (resources == null || !Resources.class.equals(resources.getClass())) {
                return false;
            }
            Collection content = resources.getContent();
            if (content.isEmpty()) {
                return false;
            }
            Object element = content.iterator().next();
            if (!(element instanceof Resource)) {
                return false;
            }
            TypeInformation resourceTypeInformation = target.getSuperTypeInformation(Resources.class).getComponentType();
            return ResourceProcessorWrapper.isValueTypeMatch((Resource)element, resourceTypeInformation);
        }
    }

    private static class ResourceProcessorWrapper
    extends DefaultProcessorWrapper {
        public ResourceProcessorWrapper(ResourceProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(TypeInformation<?> typeInformation, Object value) {
            if (!RESOURCE_TYPE.isAssignableFrom(typeInformation)) {
                return false;
            }
            return super.supports(typeInformation, value) || ResourceProcessorWrapper.isValueTypeMatch((Resource)value, this.getTargetType());
        }

        private static boolean isValueTypeMatch(Resource<?> resource, TypeInformation<?> target) {
            if (resource == null || !target.getType().isAssignableFrom(resource.getClass())) {
                return false;
            }
            Object content = resource.getContent();
            if (content == null) {
                return false;
            }
            TypeInformation typeInfo = target.getSuperTypeInformation(Resource.class);
            return null != typeInfo && typeInfo.getComponentType().getType().isAssignableFrom(content.getClass());
        }
    }

    private static class DefaultProcessorWrapper
    implements ProcessorWrapper {
        private final ResourceProcessor<?> processor;
        private final TypeInformation<?> targetType;

        public DefaultProcessorWrapper(ResourceProcessor<?> processor) {
            Assert.notNull(processor);
            this.processor = processor;
            this.targetType = ClassTypeInformation.from(processor.getClass()).getSuperTypeInformation(ResourceProcessor.class).getComponentType();
        }

        @Override
        public boolean supports(TypeInformation<?> typeInformation, Object value) {
            return this.targetType.isAssignableFrom(typeInformation);
        }

        @Override
        public Object invokeProcessor(Object object) {
            return this.processor.process((ResourceSupport)object);
        }

        public int getOrder() {
            return CustomOrderAwareComparator.INSTANCE.getOrder(this.processor);
        }

        public TypeInformation<?> getTargetType() {
            return this.targetType;
        }
    }

    private static interface ProcessorWrapper
    extends Ordered {
        public boolean supports(TypeInformation<?> var1, Object var2);

        public Object invokeProcessor(Object var1);
    }
}

