/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.UriDomainClassConverter;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

public class PersistentEntityJackson2Module
extends SimpleModule
implements InitializingBean {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_TYPE = TypeDescriptor.valueOf(URI.class);
    private final ResourceMappings mappings;
    private final ConversionService conversionService;
    @Autowired
    private Repositories repositories;
    @Autowired
    private RepositoryRestConfiguration config;
    @Autowired
    private UriDomainClassConverter uriDomainClassConverter;

    public PersistentEntityJackson2Module(ResourceMappings resourceMappings, ConversionService conversionService) {
        super(new Version(1, 1, 0, "BUILD-SNAPSHOT", "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)resourceMappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.mappings = resourceMappings;
        this.conversionService = conversionService;
        this.addSerializer((JsonSerializer)new ResourceSerializer());
    }

    public static boolean maybeAddAssociationLink(RepositoryLinkBuilder builder, ResourceMappings mappings, PersistentProperty<?> persistentProperty, List<Link> links) {
        Assert.isTrue((boolean)persistentProperty.isAssociation(), (String)"PersistentProperty must be an association!");
        ResourceMetadata ownerMetadata = mappings.getMappingFor(persistentProperty.getOwner().getType());
        if (!ownerMetadata.isManagedResource(persistentProperty)) {
            return false;
        }
        ResourceMapping propertyMapping = ownerMetadata.getMappingFor(persistentProperty);
        if (propertyMapping.isExported()) {
            links.add(builder.slash(propertyMapping.getPath()).withRel(propertyMapping.getRel()));
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        for (Class domainType : this.repositories) {
            PersistentEntity pe = this.repositories.getPersistentEntity(domainType);
            if (null == pe) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("The domain class {} does not have PersistentEntity metadata.", (Object)domainType.getName());
                continue;
            }
            this.addDeserializer(domainType, (JsonDeserializer)new ResourceDeserializer(pe));
        }
    }

    private static class MapResource
    extends Resource<Map<String, Object>> {
        public MapResource(Map<String, Object> content, Iterable<Link> links) {
            super(content, links);
        }

        @JsonIgnore
        public Map<String, Object> getContent() {
            return (Map)super.getContent();
        }

        @JsonAnyGetter
        public Map<String, Object> any() {
            return this.getContent();
        }
    }

    private class ResourceSerializer
    extends StdSerializer<PersistentEntityResource<?>> {
        private ResourceSerializer() {
            super(PersistentEntityResource.class);
        }

        public void serialize(PersistentEntityResource<?> resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing PersistentEntity " + resource.getPersistentEntity());
            }
            Object obj = resource.getContent();
            final PersistentEntity<?, ?> entity = resource.getPersistentEntity();
            final BeanWrapper wrapper = BeanWrapper.create((Object)obj, null);
            Object entityId = wrapper.getProperty(entity.getIdProperty());
            final ResourceMetadata metadata = PersistentEntityJackson2Module.this.mappings.getMappingFor(entity.getType());
            final RepositoryLinkBuilder builder = new RepositoryLinkBuilder(metadata, PersistentEntityJackson2Module.this.config.getBaseUri()).slash(entityId);
            final ArrayList<Link> links = new ArrayList<Link>();
            links.addAll(resource.getLinks());
            final LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            try {
                entity.doWithProperties(new SimplePropertyHandler(){

                    public void doWithPersistentProperty(PersistentProperty<?> property) {
                        boolean idAvailableAndShallNotBeExposed;
                        boolean bl = idAvailableAndShallNotBeExposed = property.isIdProperty() && !PersistentEntityJackson2Module.this.config.isIdExposedFor(entity.getType());
                        if (idAvailableAndShallNotBeExposed) {
                            return;
                        }
                        model.put(property.getName(), wrapper.getProperty(property));
                    }
                });
                entity.doWithAssociations(new SimpleAssociationHandler(){

                    public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                        PersistentProperty property = association.getInverse();
                        if (PersistentEntityJackson2Module.maybeAddAssociationLink(builder, PersistentEntityJackson2Module.this.mappings, property, links)) {
                            return;
                        }
                        if (metadata.isExported(property)) {
                            model.put(property.getName(), wrapper.getProperty(property));
                        }
                    }
                });
                MapResource mapResource = new MapResource(model, links);
                jgen.writeObject((Object)mapResource);
            }
            catch (IllegalStateException e) {
                throw (IOException)e.getCause();
            }
        }
    }

    private class ResourceDeserializer<T>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 8195592798684027681L;
        private final PersistentEntity<?, ?> persistentEntity;

        private ResourceDeserializer(PersistentEntity<?, ?> persistentEntity) {
            super(persistentEntity.getType());
            this.persistentEntity = persistentEntity;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object entity = BeanUtils.instantiateClass((Class)this.handledType());
            BeanWrapper wrapper = BeanWrapper.create((Object)entity, (ConversionService)PersistentEntityJackson2Module.this.conversionService);
            ResourceMetadata metadata = PersistentEntityJackson2Module.this.mappings.getMappingFor(this.handledType());
            JsonToken tok = jp.nextToken();
            while (tok != JsonToken.END_OBJECT) {
                String name = jp.getCurrentName();
                switch (tok) {
                    case FIELD_NAME: {
                        PersistentProperty persistentProperty;
                        if ("href".equals(name)) {
                            URI uri = URI.create(jp.nextTextValue());
                            TypeDescriptor entityType = TypeDescriptor.forObject((Object)entity);
                            if (!PersistentEntityJackson2Module.this.uriDomainClassConverter.matches(URI_TYPE, entityType)) break;
                            entity = PersistentEntityJackson2Module.this.uriDomainClassConverter.convert((Object)uri, URI_TYPE, entityType);
                            break;
                        }
                        if ("rel".equals(name) || null == (persistentProperty = this.persistentEntity.getPersistentProperty(name))) break;
                        Object val = null;
                        if ("links".equals(name)) {
                            tok = jp.nextToken();
                            if (tok == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                }
                                break;
                            }
                            if (tok == JsonToken.VALUE_NULL) break;
                            throw new HttpMessageNotReadableException("Property 'links' is not of array type. Either eliminate this property from the document or make it an array.");
                        }
                        if (null == persistentProperty) break;
                        if (persistentProperty.isCollectionLike()) {
                            Class collectionType = persistentProperty.getType();
                            Collection collection = CollectionFactory.createCollection((Class)collectionType, (int)0);
                            tok = jp.nextToken();
                            if (tok == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                    Object cval = jp.readValueAs(persistentProperty.getComponentType());
                                    collection.add(cval);
                                }
                                val = collection;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Collection.");
                                val = null;
                            }
                        } else if (persistentProperty.isMap()) {
                            Class mapType = persistentProperty.getType();
                            Map map = CollectionFactory.createMap((Class)mapType, (int)0);
                            tok = jp.nextToken();
                            if (tok == JsonToken.START_OBJECT) {
                                do {
                                    name = jp.getCurrentName();
                                    tok = jp.nextToken();
                                    Object mval = jp.readValueAs(persistentProperty.getMapValueType());
                                    map.put(name, mval);
                                } while ((tok = jp.nextToken()) != JsonToken.END_OBJECT);
                                val = map;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Map.");
                                val = null;
                            }
                        } else {
                            tok = jp.nextToken();
                            if (tok != JsonToken.VALUE_NULL) {
                                val = jp.readValueAs(persistentProperty.getType());
                            }
                        }
                        wrapper.setProperty(persistentProperty, val, false);
                        break;
                    }
                }
                tok = jp.nextToken();
            }
            return (T)entity;
        }
    }
}

