/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.support.DomainObjectMerger;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.ResourceType;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.UriTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositoryEntityController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}";
    private final EntityLinks entityLinks;
    private final RepositoryRestConfiguration config;
    private final ConversionService conversionService;
    private final DomainObjectMerger domainObjectMerger;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryEntityController(Repositories repositories, RepositoryRestConfiguration config, EntityLinks entityLinks, PagedResourcesAssembler<Object> assembler, @Qualifier(value="defaultConversionService") ConversionService conversionService, DomainObjectMerger domainObjectMerger) {
        super(assembler);
        this.entityLinks = entityLinks;
        this.config = config;
        this.conversionService = conversionService;
        this.domainObjectMerger = domainObjectMerger;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET})
    public Resources<?> getCollectionResource(RootResourceInformation resourceInformation, Pageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.COLLECTION);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (null == invoker) {
            throw new ResourceNotFoundException();
        }
        Iterable results = pageable != null ? invoker.invokeFindAll(pageable) : invoker.invokeFindAll(sort);
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        SearchResourceMappings searchMappings = metadata.getSearchResourceMappings();
        ArrayList<Link> links = new ArrayList<Link>();
        if (searchMappings.isExported()) {
            links.add(this.entityLinks.linkFor(metadata.getDomainType()).slash((Object)searchMappings.getPath()).withRel(searchMappings.getRel()));
        }
        Resources resources = this.resultToResources(results, assembler);
        resources.add(links);
        return resources;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public Resources<?> getCollectionResourceCompact(RootResourceInformation repoRequest, Pageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Resources<?> resources = this.getCollectionResource(repoRequest, pageable, sort, assembler);
        ArrayList<Link> links = new ArrayList<Link>(resources.getLinks());
        for (Resource resource : resources.getContent()) {
            PersistentEntityResource persistentEntityResource = (PersistentEntityResource)resource;
            links.add(this.resourceLink(repoRequest, persistentEntityResource));
        }
        if (resources instanceof PagedResources) {
            return new PagedResources(Collections.emptyList(), ((PagedResources)resources).getMetadata(), links);
        }
        return new Resources(Collections.emptyList(), links);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST})
    public ResponseEntity<ResourceSupport> postCollectionResource(RootResourceInformation resourceInformation, PersistentEntityResource<?> payload, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.POST, ResourceType.COLLECTION);
        return this.createAndReturn(payload.getContent(), resourceInformation.getInvoker(), assembler);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Resource<?>> getItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.ITEM);
        RepositoryInvoker repoMethodInvoker = resourceInformation.getInvoker();
        if (!repoMethodInvoker.exposesFindOne()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Object domainObj = repoMethodInvoker.invokeFindOne(id);
        if (domainObj == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(assembler.toResource(domainObj), HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<? extends ResourceSupport> putItemResource(RootResourceInformation resourceInformation, PersistentEntityResource<Object> payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.PUT, ResourceType.ITEM);
        Object domainObject = this.conversionService.convert((Object)id, resourceInformation.getDomainType());
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (domainObject == null) {
            BeanWrapper incomingWrapper = BeanWrapper.create((Object)payload.getContent(), (ConversionService)this.conversionService);
            incomingWrapper.setProperty(payload.getPersistentEntity().getIdProperty(), (Object)id);
            return this.createAndReturn(incomingWrapper.getBean(), invoker, assembler);
        }
        return this.mergeAndReturn(payload.getContent(), domainObject, invoker, HttpMethod.PUT, assembler);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResourceSupport> patchItemResource(RootResourceInformation resourceInformation, PersistentEntityResource<Object> payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        resourceInformation.verifySupportedMethod(HttpMethod.PATCH, ResourceType.ITEM);
        Object domainObject = this.conversionService.convert((Object)id, resourceInformation.getDomainType());
        if (domainObject == null) {
            throw new ResourceNotFoundException();
        }
        return this.mergeAndReturn(payload.getContent(), domainObject, resourceInformation.getInvoker(), HttpMethod.PATCH, assembler);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.DELETE, ResourceType.ITEM);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object domainObj = invoker.invokeFindOne(id);
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(domainObj));
        invoker.invokeDelete(id);
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(domainObj));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private ResponseEntity<ResourceSupport> mergeAndReturn(Object incoming, Object domainObject, RepositoryInvoker invoker, HttpMethod httpMethod, PersistentEntityResourceAssembler assembler) {
        DomainObjectMerger.NullHandlingPolicy nullPolicy = httpMethod.equals((Object)HttpMethod.PATCH) ? DomainObjectMerger.NullHandlingPolicy.IGNORE_NULLS : DomainObjectMerger.NullHandlingPolicy.APPLY_NULLS;
        this.domainObjectMerger.merge(incoming, domainObject, nullPolicy);
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(domainObject));
        Object obj = invoker.invokeSave(domainObject);
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(domainObject));
        HttpHeaders headers = new HttpHeaders();
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            this.addLocationHeader(headers, assembler, obj);
        }
        if (this.config.isReturnBodyOnUpdate()) {
            return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, assembler.toResource(obj));
        }
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT, headers);
    }

    private ResponseEntity<ResourceSupport> createAndReturn(Object domainObject, RepositoryInvoker invoker, PersistentEntityResourceAssembler assembler) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeCreateEvent(domainObject));
        Object savedObject = invoker.invokeSave(domainObject);
        this.publisher.publishEvent((ApplicationEvent)new AfterCreateEvent(savedObject));
        HttpHeaders headers = new HttpHeaders();
        this.addLocationHeader(headers, assembler, savedObject);
        PersistentEntityResource<Object> resource = this.config.isReturnBodyOnCreate() ? assembler.toResource(savedObject) : null;
        return ControllerUtils.toResponseEntity(HttpStatus.CREATED, headers, resource);
    }

    private void addLocationHeader(HttpHeaders headers, PersistentEntityResourceAssembler assembler, Object source) {
        String selfLink = assembler.getSelfLinkFor(source).getHref();
        headers.setLocation(new UriTemplate(selfLink).expand(new Object[0]));
    }
}

