/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.ResourceType;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class RootResourceInformation {
    private final ResourceMetadata resourceMetadata;
    private final RepositoryInvoker invoker;
    private final PersistentEntity<?, ?> persistentEntity;

    public RootResourceInformation(ResourceMetadata metadata, PersistentEntity<?, ?> entity, RepositoryInvoker invoker) {
        this.resourceMetadata = metadata;
        if (this.resourceMetadata == null || !this.resourceMetadata.isExported()) {
            this.invoker = null;
            this.persistentEntity = null;
        } else {
            this.invoker = invoker;
            this.persistentEntity = entity;
        }
    }

    public Class<?> getDomainType() {
        return this.resourceMetadata.getDomainType();
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    public SearchResourceMappings getSearchMappings() {
        return this.resourceMetadata.getSearchResourceMappings();
    }

    public RepositoryInvoker getInvoker() {
        return this.invoker;
    }

    public PersistentEntity<?, ?> getPersistentEntity() {
        return this.persistentEntity;
    }

    public Collection<HttpMethod> getSupportedMethods(ResourceType resourcType) {
        Assert.notNull((Object)((Object)resourcType), (String)"Resource type must not be null!");
        if (this.invoker == null) {
            return Collections.emptySet();
        }
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        switch (resourcType) {
            case COLLECTION: {
                if (this.invoker.exposesFindAll()) {
                    methods.add(HttpMethod.GET);
                }
                if (!this.invoker.exposesSave()) break;
                methods.add(HttpMethod.POST);
                break;
            }
            case ITEM: {
                if (this.invoker.exposesDelete() && this.invoker.hasFindOneMethod()) {
                    methods.add(HttpMethod.DELETE);
                }
                if (this.invoker.exposesFindOne()) {
                    methods.add(HttpMethod.GET);
                }
                if (!this.invoker.exposesSave()) break;
                methods.add(HttpMethod.PUT);
                methods.add(HttpMethod.PATCH);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported resource type %s!", new Object[]{resourcType}));
            }
        }
        return Collections.unmodifiableSet(methods);
    }

    public boolean supports(HttpMethod httpMethod, ResourceType resourceType) {
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null!");
        Assert.notNull((Object)((Object)resourceType), (String)"Resource type must not be null!");
        return this.getSupportedMethods(resourceType).contains(httpMethod);
    }

    public void verifySupportedMethod(HttpMethod httpMethod, ResourceType resourceType) throws HttpRequestMethodNotSupportedException {
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null!");
        Assert.notNull((Object)((Object)resourceType), (String)"Resource type must not be null!");
        Collection<HttpMethod> supportedMethods = this.getSupportedMethods(resourceType);
        if (!supportedMethods.contains(httpMethod)) {
            HashSet<String> stringMethods = new HashSet<String>();
            for (HttpMethod supportedMethod : supportedMethods) {
                stringMethods.add(supportedMethod.name());
            }
            throw new HttpRequestMethodNotSupportedException(httpMethod.name(), stringMethods);
        }
    }
}

