/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String ERROR_MESSAGE = "Could not read an object of type %s from the request! Converter %s returned null!";
    private static final String NO_CONVERTER_FOUND = "No suitable HttpMessageConverter found to read request body into object of type %s from request with content type of %s!";
    private final RootResourceInformationHandlerMethodArgumentResolver repoRequestResolver;
    private final List<HttpMessageConverter<?>> messageConverters;

    public PersistentEntityResourceHandlerMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters, RootResourceInformationHandlerMethodArgumentResolver repositoryRequestResolver) {
        Assert.notEmpty(messageConverters, (String)"MessageConverters must not be null or empty!");
        Assert.notNull((Object)repositoryRequestResolver, (String)"RootResourceInformationHandlerMethodArgumentResolver must not be empty!");
        this.messageConverters = messageConverters;
        this.repoRequestResolver = repositoryRequestResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResource.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RootResourceInformation resourceInformation = this.repoRequestResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        ServletServerHttpRequest request = new ServletServerHttpRequest(nativeRequest);
        Class domainType = resourceInformation.getPersistentEntity().getType();
        MediaType contentType = request.getHeaders().getContentType();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canRead(domainType, contentType)) continue;
            Object obj = converter.read(domainType, (HttpInputMessage)request);
            if (obj == null) {
                throw new HttpMessageNotReadableException(String.format(ERROR_MESSAGE, domainType, converter));
            }
            return new PersistentEntityResource<Object>(resourceInformation.getPersistentEntity(), obj, new Link[0]);
        }
        throw new HttpMessageNotReadableException(String.format(NO_CONVERTER_FOUND, domainType, contentType));
    }
}

