/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.core.AbstractEntityLinks;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryEntityLinks
extends AbstractEntityLinks {
    private final Repositories repositories;
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration config;
    private final HateoasPageableHandlerMethodArgumentResolver resolver;
    private final PluginRegistry<BackendIdConverter, Class<?>> idConverters;

    @Autowired
    public RepositoryEntityLinks(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration config, HateoasPageableHandlerMethodArgumentResolver resolver, PluginRegistry<BackendIdConverter, Class<?>> idConverters) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)resolver, (String)"HateoasPageableHandlerMethodArgumentResolver must not be null!");
        Assert.notNull(idConverters, (String)"Id converter registry must not be null!");
        this.repositories = repositories;
        this.mappings = mappings;
        this.config = config;
        this.resolver = resolver;
        this.idConverters = idConverters;
    }

    public boolean supports(Class<?> delimiter) {
        return this.repositories.hasRepositoryFor(delimiter);
    }

    public LinkBuilder linkFor(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        return new RepositoryLinkBuilder(metadata, this.config.getBaseUri());
    }

    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.linkFor(type);
    }

    public Link linkToCollectionResource(Class<?> type) {
        ProjectionDefinitionConfiguration projectionConfiguration;
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        TemplateVariables variables = new TemplateVariables(new TemplateVariable[0]);
        String href = this.linkFor(type).withSelfRel().getHref();
        if (metadata.isPagingResource()) {
            UriComponents components = UriComponentsBuilder.fromUriString((String)href).build();
            variables = variables.concat(this.resolver.getPaginationTemplateVariables(null, components));
        }
        if ((projectionConfiguration = this.config.projectionConfiguration()).hasProjectionFor(type)) {
            variables = variables.concat(new TemplateVariable[]{new TemplateVariable(projectionConfiguration.getParameterName(), TemplateVariable.VariableType.REQUEST_PARAM)});
        }
        return variables.asList().isEmpty() ? this.linkFor(type).withRel(metadata.getRel()) : new Link(new UriTemplate(href, variables), metadata.getRel());
    }

    public Link linkToSingleResource(Class<?> type, Object id) {
        Assert.isInstanceOf(Serializable.class, (Object)id, (String)"Id must be assignable to Serializable!");
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        String mappedId = ((BackendIdConverter)this.idConverters.getPluginFor(type, (Plugin)BackendIdConverter.DefaultIdConverter.INSTANCE)).toRequestId((Serializable)id, type);
        Link link = this.linkFor(type).slash((Object)mappedId).withRel(metadata.getItemResourceRel());
        ProjectionDefinitionConfiguration projectionConfiguration = this.config.projectionConfiguration();
        if (!projectionConfiguration.hasProjectionFor(type)) {
            return link;
        }
        String parameterName = projectionConfiguration.getParameterName();
        TemplateVariables templateVariables = new TemplateVariables(new TemplateVariable[]{new TemplateVariable(parameterName, TemplateVariable.VariableType.REQUEST_PARAM)});
        UriTemplate template = new UriTemplate(link.getHref(), templateVariables);
        return new Link(template.toString(), metadata.getItemResourceRel());
    }
}

