/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RepositoryRestHandlerMapping
extends RequestMappingHandlerMapping {
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration config;
    private JpaHelper jpaHelper;

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config) {
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        this.mappings = mappings;
        this.config = config;
        this.setOrder(2147483547);
    }

    public void setJpaHelper(JpaHelper jpaHelper) {
        this.jpaHelper = jpaHelper;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest origRequest) throws Exception {
        String acceptType = origRequest.getHeader("Accept");
        if (null == acceptType) {
            acceptType = this.config.getDefaultMediaType().toString();
        }
        List acceptHeaderTypes = MediaType.parseMediaTypes((String)acceptType);
        ArrayList<MediaType> acceptableTypes = new ArrayList<MediaType>();
        for (MediaType mt : acceptHeaderTypes) {
            if ("*".equals(mt.getType()) && "*".equals(mt.getSubtype()) || "application".equals(mt.getType()) && "*".equals(mt.getSubtype())) {
                mt = this.config.getDefaultMediaType();
            }
            if (acceptableTypes.contains(mt)) continue;
            acceptableTypes.add(mt);
        }
        acceptType = acceptableTypes.size() > 1 ? StringUtils.collectionToDelimitedString(acceptableTypes, (String)",") : (acceptableTypes.size() == 1 ? ((MediaType)acceptableTypes.get(0)).toString() : this.config.getDefaultMediaType().toString());
        String uri = new BaseUri(this.config.getBaseUri()).getRepositoryLookupPath(lookupPath);
        if (uri == null) {
            return null;
        }
        uri = StringUtils.hasText((String)uri) ? uri : "/";
        DefaultAcceptTypeHttpServletRequest request = new DefaultAcceptTypeHttpServletRequest(origRequest, acceptType, uri);
        if (uri.equals("/")) {
            return super.lookupHandlerMethod("/", (HttpServletRequest)request);
        }
        String[] parts = uri.split("/");
        if (this.mappings.exportsTopLevelResourceFor(parts[uri.startsWith("/") ? 1 : 0])) {
            return super.lookupHandlerMethod(uri, (HttpServletRequest)request);
        }
        return null;
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, RepositoryRestController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.jpaHelper) {
            for (WebRequestInterceptor o : this.jpaHelper.getInterceptors()) {
                interceptors.add(o);
            }
        }
    }

    private static class DefaultAcceptTypeHttpServletRequest
    extends HttpServletRequestWrapper {
        private final String defaultAcceptType;
        private final String requestUri;

        private DefaultAcceptTypeHttpServletRequest(HttpServletRequest request, String defaultAcceptType) {
            this(request, defaultAcceptType, null);
        }

        private DefaultAcceptTypeHttpServletRequest(HttpServletRequest request, String defaultAcceptType, String requestUri) {
            super(request);
            this.defaultAcceptType = defaultAcceptType;
            this.requestUri = requestUri;
        }

        public String getHeader(String name) {
            if ("accept".equals(name.toLowerCase())) {
                return this.defaultAcceptType;
            }
            return super.getHeader(name);
        }

        public String getRequestURI() {
            return this.requestUri != null ? this.requestUri : super.getRequestURI();
        }

        public String getServletPath() {
            return this.requestUri != null ? this.requestUri : super.getServletPath();
        }
    }
}

