/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoModule;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedHandlerBeanPostProcessor;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.invoke.DefaultRepositoryInvokerFactory;
import org.springframework.data.rest.core.invoke.RepositoryInvokerFactory;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.rest.core.projection.ProxyProjectionFactory;
import org.springframework.data.rest.core.support.DomainObjectMerger;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.util.UUIDConverter;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.BaseUriAwareController;
import org.springframework.data.rest.webmvc.BaseUriAwareHandlerMapping;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.alps.AlpsJsonHttpMessageConverter;
import org.springframework.data.rest.webmvc.alps.AlpsResourceProcessor;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.convert.StringToDistanceConverter;
import org.springframework.data.rest.webmvc.convert.StringToPointConverter;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.DefaultedPageableHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@ComponentScan(basePackageClasses={RepositoryRestController.class}, includeFilters={@ComponentScan.Filter(value={BaseUriAwareController.class})}, useDefaultFilters=false)
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*.xml"})
@Import(value={SpringDataJacksonConfiguration.class})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration {
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    @Autowired
    ListableBeanFactory beanFactory;
    @Autowired(required=false)
    List<BackendIdConverter> idConverters = Collections.emptyList();
    @Autowired(required=false)
    RelProvider relProvider;
    @Autowired(required=false)
    CurieProvider curieProvider;
    @Autowired
    GeoModule geoModule;

    @Bean
    public Repositories repositories() {
        return new Repositories(this.beanFactory);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        ArrayList<MappingContext> arrayList = new ArrayList<MappingContext>();
        for (MappingContext context : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, MappingContext.class).values()) {
            arrayList.add(context);
        }
        return new PersistentEntities(arrayList);
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        conversionService.addConverter((GenericConverter)UUIDConverter.INSTANCE);
        this.addFormatters((FormatterRegistry)conversionService);
        this.configureConversionService((ConfigurableConversionService)conversionService);
        if (!conversionService.canConvert(String.class, Point.class)) {
            conversionService.addConverter((Converter)StringToPointConverter.INSTANCE);
        }
        if (!conversionService.canConvert(String.class, Distance.class)) {
            conversionService.addConverter((Converter)StringToDistanceConverter.INSTANCE);
        }
        return conversionService;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<Repositories> repositories) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(repositories);
        this.configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public RepositoryRestConfiguration config() {
        ProjectionDefinitionConfiguration configuration = new ProjectionDefinitionConfiguration();
        for (Class<?> projection : this.getProjections(this.repositories())) {
            configuration.addProjection(projection);
        }
        RepositoryRestConfiguration config = new RepositoryRestConfiguration(configuration, this.metadataConfiguration());
        this.configureRepositoryRestConfiguration(config);
        return config;
    }

    @Bean
    public MetadataConfiguration metadataConfiguration() {
        return new MetadataConfiguration();
    }

    @Bean
    public BaseUri baseUri() {
        return new BaseUri(this.config().getBaseUri());
    }

    @Bean
    public static AnnotatedHandlerBeanPostProcessor annotatedHandlerBeanPostProcessor() {
        return new AnnotatedHandlerBeanPostProcessor();
    }

    @Bean
    public DomainObjectMerger domainObjectMerger() throws Exception {
        return new DomainObjectMerger(this.repositories(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver() {
        return new RootResourceInformationHandlerMethodArgumentResolver(this.repositories(), this.repositoryInvokerFactory(), this.resourceMetadataHandlerMethodArgumentResolver());
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver() {
        return new ResourceMetadataHandlerMethodArgumentResolver(this.repositories(), this.resourceMappings(), this.baseUri());
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver() {
        return new BackendIdHandlerMethodArgumentResolver(this.backendIdConverterRegistry(), this.resourceMetadataHandlerMethodArgumentResolver(), this.baseUri());
    }

    @Bean
    public RepositoryEntityLinks entityLinks() {
        return new RepositoryEntityLinks(this.repositories(), this.resourceMappings(), this.config(), this.pageableResolver(), this.backendIdConverterRegistry());
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        return new PersistentEntityResourceHandlerMethodArgumentResolver(messageConverters, this.repoRequestArgumentResolver(), this.backendIdHandlerMethodArgumentResolver(), new DomainObjectReader(this.persistentEntities(), this.resourceMappings()));
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter() {
        return new PersistentEntityToJsonSchemaConverter(this.persistentEntities(), this.resourceMappings(), this.resourceDescriptionMessageSourceAccessor(), (EntityLinks)this.entityLinks());
    }

    @Bean
    public MessageSourceAccessor resourceDescriptionMessageSourceAccessor() {
        try {
            PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
            propertiesFactoryBean.setLocation((Resource)new ClassPathResource("rest-default-messages.properties"));
            propertiesFactoryBean.afterPropertiesSet();
            ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
            messageSource.setBasename("classpath:rest-messages");
            messageSource.setCommonMessages(propertiesFactoryBean.getObject());
            return new MessageSourceAccessor((MessageSource)messageSource);
        }
        catch (Exception o_O) {
            throw new BeanCreationException("resourceDescriptionMessageSourceAccessor", "", (Throwable)o_O);
        }
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module());
        return mapper;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (!this.config().useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = this.config().useHalAsDefaultJsonMediaType() ? 0x7FFFFFFE : 0x7FFFFFF5;
        mediaTypes.addAll(Arrays.asList(RestMediaTypes.SCHEMA_JSON, RestMediaTypes.JSON_PATCH_JSON, RestMediaTypes.MERGE_PATCH_JSON, RestMediaTypes.SPRING_DATA_VERBOSE_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON));
        ResourceSupportHttpMessageConverter jacksonConverter = new ResourceSupportHttpMessageConverter(order);
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        return jacksonConverter;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.HAL_JSON);
        if (this.config().useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = this.config().useHalAsDefaultJsonMediaType() ? 0x7FFFFFF5 : 0x7FFFFFFE;
        ResourceSupportHttpMessageConverter converter = new ResourceSupportHttpMessageConverter(order);
        converter.setObjectMapper(this.halObjectMapper());
        converter.setSupportedMediaTypes(mediaTypes);
        return converter;
    }

    @Bean
    public ObjectMapper halObjectMapper() {
        RelProvider defaultedRelProvider = this.relProvider != null ? this.relProvider : new EvoInflectorRelProvider();
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(defaultedRelProvider, this.curieProvider);
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module());
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)instantiator);
        return mapper;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        Collection beans = this.beanFactory.getBeansOfType(ResourceProcessor.class, false, false).values();
        ArrayList processors = new ArrayList(beans.size());
        for (ResourceProcessor bean : beans) {
            processors.add(bean);
        }
        AnnotationAwareOrderComparator.sort(processors);
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)this.defaultConversionService());
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(), processors);
        handlerAdapter.setWebBindingInitializer((WebBindingInitializer)initializer);
        handlerAdapter.setMessageConverters(messageConverters);
        return handlerAdapter;
    }

    @Bean
    public RequestMappingHandlerMapping repositoryExporterHandlerMapping() {
        RepositoryRestHandlerMapping mapping = new RepositoryRestHandlerMapping(this.resourceMappings(), this.config());
        mapping.setJpaHelper(this.jpaHelper());
        return mapping;
    }

    @Bean
    public RequestMappingHandlerMapping fallbackMapping() {
        return new BaseUriAwareHandlerMapping(this.config());
    }

    @Bean
    public ResourceMappings resourceMappings() {
        Repositories repositories = this.repositories();
        RepositoryRestConfiguration config = this.config();
        return new RepositoryResourceMappings(config, repositories);
    }

    protected Module persistentEntityJackson2Module() {
        PersistentEntities entities = this.persistentEntities();
        return new PersistentEntityJackson2Module(this.resourceMappings(), entities, this.config(), new UriToEntityConverter(entities, (ConversionService)this.defaultConversionService()));
    }

    @Bean
    public ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers());
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        er.setMessageConverters(messageConverters);
        this.configureExceptionHandlerExceptionResolver(er);
        return er;
    }

    @Bean
    public RepositoryInvokerFactory repositoryInvokerFactory() {
        return new DefaultRepositoryInvokerFactory(this.repositories(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        if (this.config().metadataConfiguration().alpsEnabled()) {
            messageConverters.add((HttpMessageConverter<?>)new AlpsJsonHttpMessageConverter(this.alpsConverter()));
        }
        if (this.config().getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
        } else {
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
        }
        MappingJackson2HttpMessageConverter fallbackJsonConverter = new MappingJackson2HttpMessageConverter();
        fallbackJsonConverter.setObjectMapper(this.basicObjectMapper());
        messageConverters.add((HttpMessageConverter<?>)fallbackJsonConverter);
        messageConverters.add(this.uriListHttpMessageConverter());
        return messageConverters;
    }

    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(this.config().getPageParamName());
        resolver.setSizeParameterName(this.config().getLimitParamName());
        resolver.setFallbackPageable((Pageable)new PageRequest(0, this.config().getDefaultPageSize()));
        resolver.setMaxPageSize(this.config().getMaxPageSize());
        return resolver;
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(this.config().getSortParamName());
        return resolver;
    }

    @Bean
    public PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry() {
        ArrayList<BackendIdConverter> converters = new ArrayList<BackendIdConverter>(this.idConverters.size());
        converters.addAll(this.idConverters);
        converters.add(BackendIdConverter.DefaultIdConverter.INSTANCE);
        return OrderAwarePluginRegistry.create(converters);
    }

    protected List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers() {
        PersistentEntityResourceAssemblerArgumentResolver peraResolver = new PersistentEntityResourceAssemblerArgumentResolver(this.repositories(), (EntityLinks)this.entityLinks(), (ProjectionDefinitions)this.config().projectionConfiguration(), (ProjectionFactory)new ProxyProjectionFactory((BeanFactory)this.beanFactory), this.resourceMappings());
        HateoasPageableHandlerMethodArgumentResolver pageableResolver = this.pageableResolver();
        DefaultedPageableHandlerMethodArgumentResolver defaultedPageableResolver = new DefaultedPageableHandlerMethodArgumentResolver((PageableHandlerMethodArgumentResolver)pageableResolver);
        return Arrays.asList(new HandlerMethodArgumentResolver[]{defaultedPageableResolver, pageableResolver, this.sortResolver(), this.serverHttpRequestMethodArgumentResolver(), this.repoRequestArgumentResolver(), this.persistentEntityArgumentResolver(), this.resourceMetadataHandlerMethodArgumentResolver(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, peraResolver, this.backendIdHandlerMethodArgumentResolver()});
    }

    protected ObjectMapper basicObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)this.geoModule);
        Jackson2DatatypeHelper.configureObjectMapper(objectMapper);
        this.configureJacksonObjectMapper(objectMapper);
        return objectMapper;
    }

    private Set<Class<?>> getProjections(Repositories repositories) {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (Class domainType : repositories) {
            packagesToScan.add(domainType.getPackage().getName());
        }
        return new AnnotatedTypeScanner(new Class[]{Projection.class}).findTypes(packagesToScan);
    }

    @Bean
    public RootResourceInformationToAlpsDescriptorConverter alpsConverter() {
        Repositories repositories = this.repositories();
        PersistentEntities persistentEntities = this.persistentEntities();
        RepositoryEntityLinks entityLinks = this.entityLinks();
        MessageSourceAccessor messageSourceAccessor = this.resourceDescriptionMessageSourceAccessor();
        RepositoryRestConfiguration config = this.config();
        ResourceMappings resourceMappings = this.resourceMappings();
        return new RootResourceInformationToAlpsDescriptorConverter(resourceMappings, repositories, persistentEntities, (EntityLinks)entityLinks, messageSourceAccessor, config, this.objectMapper());
    }

    @Bean
    public AlpsResourceProcessor alpsResourceProcessor() {
        return new AlpsResourceProcessor(this.config());
    }

    protected void configureRepositoryRestConfiguration(RepositoryRestConfiguration config) {
    }

    protected void configureConversionService(ConfigurableConversionService conversionService) {
    }

    protected void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
    }

    protected void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
    }

    protected void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
    }

    protected void configureJacksonObjectMapper(ObjectMapper objectMapper) {
    }

    private static class ResourceSupportHttpMessageConverter
    extends TypeConstrainedMappingJackson2HttpMessageConverter
    implements Ordered {
        private final int order;

        public ResourceSupportHttpMessageConverter(int order) {
            super(ResourceSupport.class);
            this.order = order;
        }

        public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
            return ResourceSupport.class.isAssignableFrom(this.getJavaType(type, contextClass).getRawClass()) && super.canRead(type, contextClass, mediaType);
        }

        public int getOrder() {
            return this.order;
        }
    }
}

