/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

public class DomainObjectReader {
    private final PersistentEntities entities;
    private final AssociationLinks associationLinks;
    private final ClassIntrospector introspector;

    public DomainObjectReader(PersistentEntities entities, ResourceMappings mappings) {
        Assert.notNull((Object)entities, (String)"PersistentEntites must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.entities = entities;
        this.associationLinks = new AssociationLinks(mappings);
        this.introspector = new BasicClassIntrospector();
    }

    public <T> T read(InputStream source, T target, ObjectMapper mapper) {
        Assert.notNull(target, (String)"Target object must not be null!");
        Assert.notNull((Object)source, (String)"InputStream must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        try {
            return this.doMerge((ObjectNode)mapper.readTree(source), target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    public <T> T readPut(final ObjectNode source, T target, ObjectMapper mapper) {
        Assert.notNull((Object)source, (String)"ObjectNode must not be null!");
        Assert.notNull(target, (String)"Existing object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        PersistentEntity entity = this.entities.getPersistentEntity(target.getClass());
        final MappedProperties properties = this.getJacksonProperties(entity, mapper);
        entity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> property) {
                boolean noValueInSource;
                String mappedName = properties.getMappedName(property);
                boolean isMappedProperty = mappedName != null;
                boolean bl = noValueInSource = !source.has(mappedName);
                if (isMappedProperty && noValueInSource) {
                    source.putNull(mappedName);
                }
            }
        });
        return this.merge(source, target, mapper);
    }

    public <T> T merge(ObjectNode source, T target, ObjectMapper mapper) {
        try {
            return this.doMerge(source, target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    private <T> T doMerge(ObjectNode root, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)root, (String)"Root ObjectNode must not be null!");
        Assert.notNull(target, (String)"Target object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        PersistentEntity entity = this.entities.getPersistentEntity(target.getClass());
        MappedProperties mappedProperties = this.getJacksonProperties(entity, mapper);
        Iterator i = root.fields();
        while (i.hasNext()) {
            BeanWrapper wrapper;
            Object nested;
            PersistentProperty<?> property;
            Map.Entry entry = (Map.Entry)i.next();
            JsonNode child = (JsonNode)entry.getValue();
            if (child.isArray()) continue;
            String fieldName = (String)entry.getKey();
            if (!mappedProperties.hasPersistentPropertyForField(fieldName)) {
                i.remove();
                continue;
            }
            if (!child.isObject() || this.associationLinks.isLinkableAssociation(property = mappedProperties.getPersistentProperty(fieldName)) || (nested = (wrapper = BeanWrapper.create(target, null)).getProperty(property)) == null || !property.isEntity()) continue;
            this.doMerge((ObjectNode)child, nested, mapper);
        }
        return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
    }

    private MappedProperties getJacksonProperties(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        BeanDescription description = this.introspector.forDeserialization(mapper.getDeserializationConfig(), mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)mapper.getDeserializationConfig());
        return new MappedProperties(entity, description);
    }

    private static class MappedProperties {
        private final Map<PersistentProperty<?>, String> propertyToFieldName = new HashMap();
        private final Map<String, PersistentProperty<?>> fieldNameToProperty = new HashMap();

        public MappedProperties(PersistentEntity<?, ?> entity, BeanDescription description) {
            for (BeanPropertyDefinition property : description.findProperties()) {
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getInternalName());
                this.propertyToFieldName.put(persistentProperty, property.getName());
                this.fieldNameToProperty.put(property.getName(), persistentProperty);
            }
        }

        public String getMappedName(PersistentProperty<?> property) {
            return this.propertyToFieldName.get(property);
        }

        public boolean hasPersistentPropertyForField(String fieldName) {
            return this.fieldNameToProperty.containsKey(fieldName);
        }

        public PersistentProperty<?> getPersistentProperty(String fieldName) {
            return this.fieldNameToProperty.get(fieldName);
        }
    }
}

