/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class RootResourceInformation {
    private final ResourceMetadata resourceMetadata;
    private final RepositoryInvoker invoker;
    private final PersistentEntity<?, ?> persistentEntity;

    public RootResourceInformation(ResourceMetadata metadata, PersistentEntity<?, ?> entity, RepositoryInvoker invoker) {
        this.resourceMetadata = metadata;
        if (this.resourceMetadata == null || !this.resourceMetadata.isExported()) {
            this.invoker = null;
            this.persistentEntity = null;
        } else {
            this.invoker = invoker;
            this.persistentEntity = entity;
        }
    }

    public Class<?> getDomainType() {
        return this.resourceMetadata.getDomainType();
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    public SearchResourceMappings getSearchMappings() {
        return this.resourceMetadata.getSearchResourceMappings();
    }

    public RepositoryInvoker getInvoker() {
        return this.invoker;
    }

    public PersistentEntity<?, ?> getPersistentEntity() {
        return this.persistentEntity;
    }

    public SupportedHttpMethods getSupportedMethods() {
        return this.resourceMetadata.getSupportedHttpMethods();
    }

    public void verifySupportedMethod(HttpMethod httpMethod, ResourceType resourceType) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        if (!this.resourceMetadata.isExported()) {
            throw new ResourceNotFoundException();
        }
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null!");
        Assert.notNull((Object)resourceType, (String)"Resource type must not be null!");
        SupportedHttpMethods httpMethods = this.resourceMetadata.getSupportedHttpMethods();
        Set supportedMethods = httpMethods.getMethodsFor(resourceType);
        if (!supportedMethods.contains(httpMethod)) {
            HashSet<String> stringMethods = new HashSet<String>();
            for (HttpMethod supportedMethod : supportedMethods) {
                stringMethods.add(supportedMethod.name());
            }
            throw new HttpRequestMethodNotSupportedException(httpMethod.name(), stringMethods);
        }
    }
}

