/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.RemoveOperation;
import com.github.fge.jsonpatch.ReplaceOperation;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.data.rest.webmvc.IncomingRequest;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class JsonPatchHandler {
    private static final Field PATH_FIELD;
    private final ObjectMapper mapper;
    private final ObjectMapper sourceMapper;
    private final DomainObjectReader reader;

    public JsonPatchHandler(ObjectMapper mapper, DomainObjectReader reader) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)reader, (String)"DomainObjectReader must not be null!");
        this.mapper = mapper;
        this.reader = reader;
        this.sourceMapper = mapper.copy();
        this.sourceMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public <T> T apply(IncomingRequest request, T target) throws Exception {
        Assert.notNull((Object)request, (String)"Request must not be null!");
        Assert.isTrue((boolean)request.isPatchRequest(), (String)"Cannot handle non-PATCH request!");
        Assert.notNull(target, (String)"Target must not be null!");
        if (request.isJsonPatchRequest()) {
            return this.applyPatch(request.getBody(), target);
        }
        return this.applyMergePatch(request.getBody(), target);
    }

    <T> T applyPatch(InputStream source, T target) throws Exception {
        JsonNode existingAsNode;
        CollectionType listOfOperationsType = this.mapper.getTypeFactory().constructCollectionType(List.class, JsonPatchOperation.class);
        List readValue = (List)this.mapper.readValue(source, (JavaType)listOfOperationsType);
        JsonNode patchedNode = existingAsNode = this.mapper.readTree(this.sourceMapper.writeValueAsBytes(target));
        for (JsonPatchOperation operation : readValue) {
            if (operation instanceof RemoveOperation) {
                JsonPointer path = (JsonPointer)ReflectionUtils.getField((Field)PATH_FIELD, (Object)operation);
                patchedNode = new ReplaceOperation(path, (JsonNode)NullNode.getInstance()).apply(patchedNode);
                continue;
            }
            patchedNode = operation.apply(patchedNode);
        }
        return this.reader.merge((ObjectNode)patchedNode, target, this.mapper);
    }

    <T> T applyMergePatch(InputStream source, T existingObject) throws Exception {
        return this.reader.read(source, existingObject, this.mapper);
    }

    <T> T applyPut(ObjectNode source, T existingObject) {
        return this.reader.readPut(source, existingObject, this.mapper);
    }

    static {
        Field field = ReflectionUtils.findField(JsonPatchOperation.class, (String)"path");
        ReflectionUtils.makeAccessible((Field)field);
        PATH_FIELD = field;
    }
}

