/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositorySearchesResource;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

@RepositoryRestController
class RepositorySearchController
extends AbstractRepositoryRestController {
    private static final String SEARCH = "/search";
    private static final String BASE_MAPPING = "/{repository}/search";
    private final RepositoryEntityLinks entityLinks;
    private final ResourceMappings mappings;
    private final PagedResourcesAssembler<Object> assembler;
    private final HateoasSortHandlerMethodArgumentResolver sortResolver;

    @Autowired
    public RepositorySearchController(PagedResourcesAssembler<Object> assembler, RepositoryEntityLinks entityLinks, ResourceMappings mappings, HateoasSortHandlerMethodArgumentResolver sortResolver, AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        super(assembler, auditableBeanWrapperFactory);
        Assert.notNull((Object)((Object)entityLinks), (String)"EntityLinks must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)sortResolver, (String)"HateoasSortHandlerMethodArgumentResolver must not be null!");
        this.entityLinks = entityLinks;
        this.mappings = mappings;
        this.assembler = assembler;
        this.sortResolver = sortResolver;
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.OPTIONS})
    public HttpEntity<?> optionsForSearches(RootResourceInformation resourceInformation) {
        this.verifySearchesExposed(resourceInformation);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.HEAD})
    public HttpEntity<?> headForSearches(RootResourceInformation resourceInformation) {
        this.verifySearchesExposed(resourceInformation);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.GET})
    public RepositorySearchesResource listSearches(RootResourceInformation resourceInformation) {
        this.verifySearchesExposed(resourceInformation);
        Links queryMethodLinks = this.entityLinks.linksToSearchResources(resourceInformation.getDomainType());
        if (queryMethodLinks.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        RepositorySearchesResource result = new RepositorySearchesResource(resourceInformation.getDomainType());
        result.add((Iterable)queryMethodLinks);
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> executeSearch(RootResourceInformation resourceInformation, WebRequest request, @PathVariable String search, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) {
        Method method = this.checkExecutability(resourceInformation, search);
        Object result = this.executeQueryMethod(resourceInformation.getInvoker(), request, method, pageable, sort, assembler);
        return new ResponseEntity(this.toResource(result, assembler, null), HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json"})
    public ResourceSupport executeSearchCompact(RootResourceInformation resourceInformation, WebRequest request, @PathVariable String repository, @PathVariable String search, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) {
        Method method = this.checkExecutability(resourceInformation, search);
        Object result = this.executeQueryMethod(resourceInformation.getInvoker(), request, method, pageable, sort, assembler);
        Object resource = this.toResource(result, assembler, null);
        ArrayList<Link> links = new ArrayList<Link>();
        if (resource instanceof Resources && ((Resources)resource).getContent() != null) {
            for (Object obj : ((Resources)resource).getContent()) {
                if (null == obj || !(obj instanceof Resource)) continue;
                Resource res = (Resource)obj;
                links.add(this.resourceLink(resourceInformation, res));
            }
        } else if (resource instanceof Resource) {
            Resource res = (Resource)resource;
            links.add(this.resourceLink(resourceInformation, res));
        }
        return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, links);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<Object> optionsForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Object> headForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Method checkExecutability(RootResourceInformation resourceInformation, String searchName) {
        SearchResourceMappings searchMapping = this.verifySearchesExposed(resourceInformation);
        Method method = searchMapping.getMappedMethod(searchName);
        if (method == null) {
            throw new ResourceNotFoundException();
        }
        return method;
    }

    private Object executeQueryMethod(RepositoryInvoker invoker, WebRequest request, Method method, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) {
        Map parameters = request.getParameterMap();
        return invoker.invokeQueryMethod(method, parameters, pageable.getPageable(), sort);
    }

    private SearchResourceMappings verifySearchesExposed(RootResourceInformation resourceInformation) {
        SearchResourceMappings resourceMappings = resourceInformation.getSearchMappings();
        if (!resourceMappings.isExported()) {
            throw new ResourceNotFoundException();
        }
        return resourceMappings;
    }
}

