/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.data.rest.webmvc.mapping.LinkCollectingAssociationHandler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.Assert;

public class PersistentEntityJackson2Module
extends SimpleModule {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_DESCRIPTOR = TypeDescriptor.valueOf(URI.class);

    public PersistentEntityJackson2Module(ResourceMappings mappings, PersistentEntities entities, RepositoryRestConfiguration config, UriToEntityConverter converter) {
        super(new Version(2, 0, 0, null, "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)entities, (String)"Repositories must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
        AssociationLinks associationLinks = new AssociationLinks(mappings);
        this.addSerializer((JsonSerializer)new PersistentEntityResourceSerializer(entities, associationLinks));
        this.setSerializerModifier(new AssociationOmittingSerializerModifier(entities, associationLinks, config));
        this.setDeserializerModifier(new AssociationUriResolvingDeserializerModifier(entities, converter, associationLinks));
    }

    private static class CollectionValueInstantiator
    extends ValueInstantiator {
        private final PersistentProperty<?> property;

        public CollectionValueInstantiator(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"Property must not be null!");
            Assert.isTrue((property.isCollectionLike() || property.isMap() ? 1 : 0) != 0, (String)"Property must be a collection or map property!");
            this.property = property;
        }

        public String getValueTypeDesc() {
            return this.property.getType().getName();
        }

        public Object createUsingDefault(DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Class collectionOrMapType = this.property.getType();
            return this.property.isMap() ? CollectionFactory.createMap((Class)collectionOrMapType, (int)0) : CollectionFactory.createCollection((Class)collectionOrMapType, (int)0);
        }
    }

    static class UriStringDeserializer
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = -2175900204153350125L;
        private final PersistentProperty<?> property;
        private final UriToEntityConverter converter;

        public UriStringDeserializer(PersistentProperty<?> property, UriToEntityConverter converter) {
            super(property.getActualType());
            this.property = property;
            this.converter = converter;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            URI uri = new UriTemplate(jp.getValueAsString()).expand(new Object[0]);
            TypeDescriptor typeDescriptor = TypeDescriptor.valueOf((Class)this.property.getActualType());
            return this.converter.convert((Object)uri, URI_DESCRIPTOR, typeDescriptor);
        }
    }

    public static class AssociationUriResolvingDeserializerModifier
    extends BeanDeserializerModifier {
        private final UriToEntityConverter converter;
        private final PersistentEntities repositories;
        private final AssociationLinks associationLinks;

        public AssociationUriResolvingDeserializerModifier(PersistentEntities repositories, UriToEntityConverter converter, AssociationLinks associationLinks) {
            Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
            Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
            this.repositories = repositories;
            this.converter = converter;
            this.associationLinks = associationLinks;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            Iterator properties = builder.getProperties();
            PersistentEntity entity = this.repositories.getPersistentEntity(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            while (properties.hasNext()) {
                SettableBeanProperty property = (SettableBeanProperty)properties.next();
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getName());
                if (!this.associationLinks.isLinkableAssociation(persistentProperty)) continue;
                UriStringDeserializer uriStringDeserializer = new UriStringDeserializer(persistentProperty, this.converter);
                if (persistentProperty.isCollectionLike()) {
                    CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(persistentProperty.getType(), persistentProperty.getActualType());
                    CollectionValueInstantiator instantiator = new CollectionValueInstantiator(persistentProperty);
                    CollectionDeserializer collectionDeserializer = new CollectionDeserializer((JavaType)collectionType, (JsonDeserializer)uriStringDeserializer, null, (ValueInstantiator)instantiator);
                    builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)collectionDeserializer), false);
                    continue;
                }
                builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)uriStringDeserializer), false);
            }
            return builder;
        }
    }

    static class AssociationOmittingSerializerModifier
    extends BeanSerializerModifier {
        private final PersistentEntities entities;
        private final RepositoryRestConfiguration configuration;
        private final AssociationLinks associationLinks;

        public AssociationOmittingSerializerModifier(PersistentEntities entities, AssociationLinks associationLinks, RepositoryRestConfiguration configuration) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
            Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
            Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
            this.entities = entities;
            this.configuration = configuration;
            this.associationLinks = associationLinks;
        }

        public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            PersistentEntity entity = this.entities.getPersistentEntity(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : builder.getProperties()) {
                PersistentProperty<?> persistentProperty = this.findProperty(writer.getName(), entity, beanDesc);
                if (persistentProperty == null) {
                    result.add(writer);
                    continue;
                }
                if (this.associationLinks.isLinkableAssociation(persistentProperty) || persistentProperty.isIdProperty() && !this.configuration.isIdExposedFor(entity.getType()) || persistentProperty.isVersionProperty()) continue;
                result.add(writer);
            }
            builder.setProperties(result);
            return builder;
        }

        private PersistentProperty<?> findProperty(String finalName, PersistentEntity<?, ?> entity, BeanDescription description) {
            for (BeanPropertyDefinition definition : description.findProperties()) {
                if (!definition.getName().equals(finalName)) continue;
                return entity.getPersistentProperty(definition.getInternalName());
            }
            return null;
        }
    }

    private static class PersistentEntityResourceSerializer
    extends StdSerializer<PersistentEntityResource> {
        private final PersistentEntities entities;
        private final AssociationLinks associationLinks;

        private PersistentEntityResourceSerializer(PersistentEntities entities, AssociationLinks links) {
            super(PersistentEntityResource.class);
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
            Assert.notNull((Object)links, (String)"AssociationLinks must not be null!");
            this.associationLinks = links;
            this.entities = entities;
        }

        public void serialize(final PersistentEntityResource resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Link id;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing PersistentEntity " + resource.getPersistentEntity());
            }
            if ((id = resource.getId()) == null) {
                throw new JsonGenerationException(String.format("No self link found resource %s!", new Object[]{resource}));
            }
            ArrayList<Link> links = new ArrayList<Link>();
            links.addAll(resource.getLinks());
            Path basePath = new Path(id.expand(new Object[0]).getHref());
            LinkCollectingAssociationHandler associationHandler = new LinkCollectingAssociationHandler(this.entities, basePath, this.associationLinks);
            resource.getPersistentEntity().doWithAssociations((SimpleAssociationHandler)associationHandler);
            for (Link link : associationHandler.getLinks()) {
                links.add(link);
            }
            Resource<Object> resourceToRender = new Resource<Object>(resource.getContent(), links){

                @JsonUnwrapped
                public Resources<?> getEmbedded() {
                    return resource.getEmbeddeds();
                }
            };
            provider.defaultSerializeValue((Object)resourceToRender, jgen);
        }
    }
}

