/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.hateoas.alps.Alps;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class AlpsJsonHttpMessageConverter
extends MappingJackson2HttpMessageConverter
implements ResponseBodyAdvice<Object> {
    private final RootResourceInformationToAlpsDescriptorConverter converter;

    public AlpsJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null!");
        this.converter = converter;
        ObjectMapper mapper = this.getObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.setPrettyPrint(true);
        this.setSupportedMediaTypes(Arrays.asList(RestMediaTypes.ALPS_JSON, MediaType.APPLICATION_JSON, MediaType.ALL));
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return (clazz.isAssignableFrom(Alps.class) || clazz.isAssignableFrom(RootResourceInformation.class)) && super.canWrite(clazz, mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        return body instanceof RootResourceInformation ? this.converter.convert((RootResourceInformation)body) : body;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return converterType.equals(AlpsJsonHttpMessageConverter.class);
    }
}

